/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.server;

import dev.vality.woody.api.interceptor.CommonInterceptor;
import dev.vality.woody.api.interceptor.EmptyCommonInterceptor;
import dev.vality.woody.api.trace.ContextUtils;
import dev.vality.woody.api.trace.TraceData;
import dev.vality.woody.api.trace.context.TraceContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(TServlet.class);
    private final TProcessor processor;
    private final TProtocolFactory inProtocolFactory;
    private final TProtocolFactory outProtocolFactory;
    private final Collection<Map.Entry<String, String>> customHeaders;
    private final CommonInterceptor defaultInterceptor = new EmptyCommonInterceptor(){
        private final Logger log = LoggerFactory.getLogger(this.getClass());

        @Override
        public boolean interceptResponse(TraceData traceData, Object providerContext, Object ... contextParams) {
            this.log.trace("Intercept response. Check on error");
            Throwable t = ContextUtils.getCallError(traceData.getServiceSpan());
            if (t != null) {
                ContextUtils.setInterceptionError(traceData.getServiceSpan(), t);
                return false;
            }
            return true;
        }
    };
    private CommonInterceptor interceptor;

    public TServlet(TProcessor processor, TProtocolFactory inProtocolFactory, TProtocolFactory outProtocolFactory, CommonInterceptor interceptor) {
        this.processor = processor;
        this.inProtocolFactory = inProtocolFactory;
        this.outProtocolFactory = outProtocolFactory;
        this.customHeaders = new ArrayList<Map.Entry<String, String>>();
        this.interceptor = interceptor == null ? this.defaultInterceptor : interceptor;
    }

    public TServlet(TProcessor processor, TProtocolFactory inProtocolFactory, TProtocolFactory outProtocolFactory) {
        this(processor, inProtocolFactory, outProtocolFactory, null);
    }

    public TServlet(TProcessor processor, TProtocolFactory protocolFactory) {
        this(processor, protocolFactory, protocolFactory);
    }

    public TServlet(TProcessor processor, TProtocolFactory protocolFactory, CommonInterceptor interceptor) {
        this(processor, protocolFactory, protocolFactory, interceptor);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TraceData traceData = TraceContext.getCurrentTraceData();
        ServletOutputStream out = null;
        try {
            ServletInputStream in = request.getInputStream();
            out = response.getOutputStream();
            response.setContentType("application/x-thrift");
            boolean success = this.interceptor.interceptRequest(traceData, request, response);
            if (!success) {
                LOG.trace("Unsuccessful intercept request: {}", (Object)traceData.getActiveSpan().getSpan());
                ContextUtils.tryThrowInterceptionError(traceData.getServiceSpan());
            }
            if (null != this.customHeaders) {
                for (Map.Entry<String, String> header : this.customHeaders) {
                    response.addHeader(header.getKey(), header.getValue());
                }
            }
            TIOStreamTransport transport = new TIOStreamTransport((InputStream)in, (OutputStream)out);
            TProtocol inProtocol = this.inProtocolFactory.getProtocol(transport);
            TProtocol outProtocol = this.outProtocolFactory.getProtocol(transport);
            this.processor.process(inProtocol, outProtocol);
        }
        catch (Throwable tw) {
            LOG.error("Unexpected exception during handle request", tw);
            ContextUtils.setCallError(traceData.getServiceSpan(), tw);
        }
        finally {
            this.flushResponse((OutputStream)out, traceData, response);
        }
    }

    private void flushResponse(OutputStream out, TraceData traceData, HttpServletResponse response) throws ServletException, IOException {
        try {
            Throwable t;
            if (!this.interceptor.interceptResponse(traceData, response, new Object[0]) && (t = ContextUtils.getInterceptionError(traceData.getServiceSpan())) != null) {
                throw new ServletException(t);
            }
            if (out != null) {
                out.flush();
            }
        }
        catch (Exception e) {
            LOG.error("Unexpected exception during flush response", e);
            throw e;
        }
        finally {
            TraceContext.getCurrentTraceData().reset();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void addCustomHeader(String key, String value) {
        this.customHeaders.add(new AbstractMap.SimpleImmutableEntry<String, String>(key, value));
    }

    public void setCustomHeaders(Collection<Map.Entry<String, String>> headers) {
        this.customHeaders.clear();
        this.customHeaders.addAll(headers);
    }
}

