/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http;

import dev.vality.woody.api.WoodyInstantiationException;
import dev.vality.woody.api.event.ClientEventListener;
import dev.vality.woody.api.flow.error.WErrorMapper;
import dev.vality.woody.api.generator.IdGenerator;
import dev.vality.woody.api.proxy.CPool2TargetProvider;
import dev.vality.woody.api.proxy.InvocationTargetProvider;
import dev.vality.woody.api.trace.context.metadata.MetadataExtensionKit;
import dev.vality.woody.thrift.impl.http.THClientBuilder;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.http.client.HttpClient;

public class THPooledClientBuilder
extends THClientBuilder {
    private final ConcurrentLinkedQueue<CPool2TargetProvider> collectedProviders = new ConcurrentLinkedQueue();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private volatile boolean collectInstance = false;
    private volatile GenericObjectPoolConfig poolConfig;
    private volatile AbandonedConfig poolAbandonedConfig;
    private boolean destroyed = false;

    @Override
    public THPooledClientBuilder withErrorMapper(WErrorMapper errorMapper) {
        return (THPooledClientBuilder)super.withErrorMapper(errorMapper);
    }

    @Override
    public THPooledClientBuilder withHttpClient(HttpClient httpClient) {
        return (THPooledClientBuilder)super.withHttpClient(httpClient);
    }

    @Override
    public THPooledClientBuilder withMetaExtensions(List<MetadataExtensionKit> extensionKits) {
        return (THPooledClientBuilder)super.withMetaExtensions(extensionKits);
    }

    @Override
    public THPooledClientBuilder withNetworkTimeout(int timeout) {
        return (THPooledClientBuilder)super.withNetworkTimeout(timeout);
    }

    @Override
    public THPooledClientBuilder withLogEnabled(boolean enabled) {
        return (THPooledClientBuilder)super.withLogEnabled(enabled);
    }

    public THPooledClientBuilder withCollectInstance(boolean collectInstance) {
        this.collectInstance = collectInstance;
        return this;
    }

    @Override
    public THPooledClientBuilder withAddress(URI address) {
        return (THPooledClientBuilder)super.withAddress(address);
    }

    @Override
    public THPooledClientBuilder withEventListener(ClientEventListener listener) {
        return (THPooledClientBuilder)super.withEventListener(listener);
    }

    @Override
    public THPooledClientBuilder withIdGenerator(IdGenerator generator) {
        return (THPooledClientBuilder)super.withIdGenerator(generator);
    }

    public THPooledClientBuilder withPoolConfig(GenericObjectPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
        return this;
    }

    public THPooledClientBuilder withPoolAbandonedConfig(AbandonedConfig poolAbandonedConfig) {
        this.poolAbandonedConfig = poolAbandonedConfig;
        return this;
    }

    @Override
    public <T> T build(Class<T> iface) throws WoodyInstantiationException {
        try {
            return this.build(iface, this.createTargetProvider(iface));
        }
        catch (WoodyInstantiationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WoodyInstantiationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> InvocationTargetProvider<T> createTargetProvider(Class<T> iface) {
        this.rwLock.readLock().lock();
        try {
            if (this.destroyed) {
                throw new IllegalStateException("Builder is already destroyed");
            }
            CPool2TargetProvider<T> targetProvider = CPool2TargetProvider.newInstance(iface, () -> new THTargetObjectFactory<Object>(() -> this.createProviderClient(iface), this::destroyProviderClient, this.isCustomHttpClient()), this.poolConfig, this.poolAbandonedConfig);
            if (this.collectInstance) {
                this.collectedProviders.add(targetProvider);
            }
            CPool2TargetProvider<T> cPool2TargetProvider = targetProvider;
            return cPool2TargetProvider;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void destroy() {
        this.rwLock.writeLock().lock();
        try {
            this.destroyed = true;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        for (CPool2TargetProvider provider : this.collectedProviders) {
            provider.close();
        }
    }

    private static class THTargetObjectFactory<T>
    extends CPool2TargetProvider.TargetObjectFactory<T> {
        private final boolean customClient;
        private final BiConsumer<Object, Boolean> destroyTargetConsumer;

        public THTargetObjectFactory(Supplier<T> targetSupplier, BiConsumer<Object, Boolean> destroyTargetConsumer, boolean customClient) {
            super(targetSupplier);
            this.customClient = customClient;
            this.destroyTargetConsumer = destroyTargetConsumer;
        }

        @Override
        public void destroyObject(PooledObject<T> p) throws Exception {
            this.destroyTargetConsumer.accept(p.getObject(), this.customClient);
            super.destroyObject(p);
        }
    }
}

