/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.flow;

import dev.vality.woody.api.flow.concurrent.WCallable;
import dev.vality.woody.api.flow.concurrent.WRunnable;
import dev.vality.woody.api.generator.ConfiguredSnowflakeIdGenerator;
import dev.vality.woody.api.generator.IdGenerator;
import dev.vality.woody.api.trace.TraceData;
import dev.vality.woody.api.trace.context.TraceContext;
import java.util.concurrent.Callable;

public class WFlow {
    private final IdGenerator traceIdGenerator;
    private final IdGenerator spanIdGenerator;

    public WFlow() {
        this(WFlow.createDefaultIdGenerator());
    }

    public WFlow(IdGenerator idGenerator) {
        this(idGenerator, idGenerator);
    }

    public WFlow(IdGenerator traceIdGenerator, IdGenerator spanIdGenerator) {
        this.traceIdGenerator = traceIdGenerator;
        this.spanIdGenerator = spanIdGenerator;
    }

    public static IdGenerator createDefaultIdGenerator() {
        return new ConfiguredSnowflakeIdGenerator();
    }

    public static WRunnable create(Runnable runnable) {
        return new WRunnable(runnable, TraceContext.getCurrentTraceData());
    }

    public static WRunnable create(Runnable runnable, TraceData traceData) {
        return new WRunnable(runnable, traceData);
    }

    public static <T> WCallable<T> create(Callable<T> callable) {
        return new WCallable<T>(callable, TraceContext.getCurrentTraceData());
    }

    public static <T> WCallable<T> create(Callable<T> callable, TraceData traceData) {
        return new WCallable<T>(callable, traceData);
    }

    public static WRunnable createFork(Runnable runnable) {
        return WFlow.create(runnable, new TraceData());
    }

    public static <T> WCallable<T> createFork(Callable<T> callable) {
        return WFlow.create(callable, new TraceData());
    }

    public static WRunnable createServiceFork(Runnable runnable, IdGenerator idGenerator) {
        return WFlow.create(runnable, TraceContext.initNewServiceTrace(new TraceData(), idGenerator, idGenerator));
    }

    public static WRunnable createServiceFork(Runnable runnable, IdGenerator traceIdGenerator, IdGenerator spanIdGenerator) {
        return WFlow.create(runnable, TraceContext.initNewServiceTrace(new TraceData(), traceIdGenerator, spanIdGenerator));
    }

    public static <T> WCallable<T> createServiceFork(Callable<T> callable, IdGenerator idGenerator) {
        return WFlow.create(callable, TraceContext.initNewServiceTrace(new TraceData(), idGenerator, idGenerator));
    }

    public static <T> WCallable<T> createServiceFork(Callable<T> callable, IdGenerator traceIdGenerator, IdGenerator spanIdGenerator) {
        return WFlow.create(callable, TraceContext.initNewServiceTrace(new TraceData(), traceIdGenerator, spanIdGenerator));
    }

    public WRunnable createServiceFork(Runnable runnable) {
        return WFlow.createServiceFork(runnable, this.traceIdGenerator, this.spanIdGenerator);
    }

    public <T> WCallable<T> createServiceFork(Callable<T> callable) {
        return WFlow.createServiceFork(callable, this.traceIdGenerator, this.spanIdGenerator);
    }
}

