/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift;

import dev.vality.woody.api.event.CallType;
import dev.vality.woody.api.trace.context.TraceContext;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessFunction<I, T extends TBase> {
    private final String methodName;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessFunction.class.getName());

    public ProcessFunction(String methodName) {
        this.methodName = methodName;
    }

    public final void process(int seqid, TProtocol iprot, TProtocol oprot, I iface) throws TException {
        TraceContext.getCurrentTraceData().getServiceSpan().getMetadata().putValue("md_call_type", (Object)(this.isOneway() ? CallType.CAST : CallType.CALL));
        T args = this.getEmptyArgsInstance();
        try {
            args.read(iprot);
        }
        catch (TProtocolException e) {
            iprot.readMessageEnd();
            TApplicationException x = new TApplicationException(7, e.getMessage());
            oprot.writeMessageBegin(new TMessage(this.getMethodName(), 3, seqid));
            x.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
            return;
        }
        iprot.readMessageEnd();
        TBase result = null;
        try {
            result = this.getResult(iface, args);
        }
        catch (TException ex) {
            LOGGER.error("Internal error processing " + this.getMethodName(), ex);
            if (this.rethrowUnhandledExceptions()) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            throw ex;
        }
        if (!this.isOneway()) {
            oprot.writeMessageBegin(new TMessage(this.getMethodName(), 2, seqid));
            result.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
        }
    }

    private void handleException(int seqid, TProtocol oprot) throws TException {
        if (!this.isOneway()) {
            TApplicationException x = new TApplicationException(6, "Internal error processing " + this.getMethodName());
            oprot.writeMessageBegin(new TMessage(this.getMethodName(), 3, seqid));
            x.write(oprot);
            oprot.writeMessageEnd();
            oprot.getTransport().flush();
        }
    }

    protected boolean rethrowUnhandledExceptions() {
        return false;
    }

    protected abstract boolean isOneway();

    public abstract TBase getResult(I var1, T var2) throws TException;

    public abstract T getEmptyArgsInstance();

    public String getMethodName() {
        return this.methodName;
    }
}

