/*
 * Decompiled with CFR 0.152.
 */
package org.apache.thrift.transport;

import dev.vality.woody.api.interceptor.CommonInterceptor;
import dev.vality.woody.api.interceptor.EmptyCommonInterceptor;
import dev.vality.woody.api.trace.ContextUtils;
import dev.vality.woody.api.trace.TraceData;
import dev.vality.woody.api.trace.context.TraceContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.thrift.TConfiguration;
import org.apache.thrift.transport.TEndpointTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class THttpClient
extends TEndpointTransport {
    private URL url_ = null;
    private final ByteArrayOutputStream requestBuffer_ = new ByteArrayOutputStream();
    private InputStream inputStream_ = null;
    private int maxConnectTimeout_ = 250;
    private int networkTimeout_ = 0;
    private Map<String, String> customHeaders_ = null;
    private final HttpHost host;
    private final HttpClient client;
    private final CommonInterceptor interceptor;

    public THttpClient(String url) throws TTransportException {
        this(url, (CommonInterceptor)null);
    }

    public THttpClient(TConfiguration config, String url) throws TTransportException {
        super(config);
        try {
            this.url_ = new URL(url);
            this.client = null;
            this.host = null;
            this.interceptor = new EmptyCommonInterceptor();
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    public THttpClient(String url, CommonInterceptor interceptor) throws TTransportException {
        super(new TConfiguration());
        try {
            this.url_ = new URL(url);
            this.client = null;
            this.host = null;
            this.interceptor = interceptor == null ? new EmptyCommonInterceptor() : interceptor;
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    public THttpClient(TConfiguration config, String url, HttpClient client) throws TTransportException {
        this(config, url, client, null);
    }

    public THttpClient(TConfiguration config, String url, HttpClient client, CommonInterceptor interceptor) throws TTransportException {
        super(config);
        try {
            this.url_ = new URL(url);
            this.client = client;
            this.host = new HttpHost(this.url_.getHost(), -1 == this.url_.getPort() ? this.url_.getDefaultPort() : this.url_.getPort(), this.url_.getProtocol());
            this.interceptor = interceptor == null ? new EmptyCommonInterceptor() : interceptor;
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    public THttpClient(String url, HttpClient client) throws TTransportException {
        this(url, client, null);
    }

    public THttpClient(String url, HttpClient client, CommonInterceptor interceptor) throws TTransportException {
        super(new TConfiguration());
        try {
            this.url_ = new URL(url);
            this.client = client;
            this.host = new HttpHost(this.url_.getHost(), -1 == this.url_.getPort() ? this.url_.getDefaultPort() : this.url_.getPort(), this.url_.getProtocol());
            this.interceptor = interceptor == null ? new EmptyCommonInterceptor() : interceptor;
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    public void setNetworkTimeout(int timeout) {
        this.networkTimeout_ = timeout;
    }

    public void setMaxConnectTimeout(int timeout) {
        this.maxConnectTimeout_ = timeout;
    }

    public void setCustomHeaders(Map<String, String> headers) {
        this.customHeaders_ = headers;
    }

    public void setCustomHeader(String key, String value) {
        if (this.customHeaders_ == null) {
            this.customHeaders_ = new HashMap<String, String>();
        }
        this.customHeaders_.put(key, value);
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        if (null != this.inputStream_) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream_ = null;
        }
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        if (this.inputStream_ == null) {
            throw new TTransportException("Response buffer is empty, no request.");
        }
        this.checkReadBytesAvailable(len);
        try {
            int ret = this.inputStream_.read(buf, off, len);
            if (ret == -1) {
                throw new TTransportException("No more data available.");
            }
            this.countConsumedMessageBytes(ret);
            return ret;
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.requestBuffer_.write(buf, off, len);
    }

    private static void consume(HttpEntity entity) throws IOException {
        InputStream instream;
        if (entity == null) {
            return;
        }
        if (entity.isStreaming() && (instream = entity.getContent()) != null) {
            instream.close();
        }
    }

    private void setMainHeaders(BiConsumer<String, String> hSetter) {
        hSetter.accept("Content-Type", "application/x-thrift");
        hSetter.accept("Accept", "application/x-thrift");
        hSetter.accept("User-Agent", "Java/THttpClient/HC");
    }

    private void setCustomHeaders(BiConsumer<String, String> hSetter) {
        if (null != this.customHeaders_) {
            for (Map.Entry<String, String> header : this.customHeaders_.entrySet()) {
                hSetter.accept(header.getKey(), header.getValue());
            }
        }
    }

    private void intercept(BooleanSupplier interception, String errMsg) throws TTransportException {
        Throwable reqErr;
        if (!interception.getAsBoolean() && (reqErr = ContextUtils.getInterceptionError(TraceContext.getCurrentTraceData().getClientSpan())) != null) {
            if (reqErr instanceof RuntimeException) {
                throw (RuntimeException)reqErr;
            }
            throw new TTransportException(errMsg, reqErr);
        }
    }

    private void flushUsingHttpClient() throws TTransportException {
        if (null == this.client) {
            throw new TTransportException("Null HttpClient, aborting.");
        }
        byte[] data = this.requestBuffer_.toByteArray();
        this.requestBuffer_.reset();
        HttpPost post = null;
        InputStream is = null;
        try {
            HttpPost newPost = post = new HttpPost(this.url_.getFile());
            this.setMainHeaders((key, val) -> newPost.setHeader((String)key, (String)val));
            this.setCustomHeaders((String key, String val) -> newPost.setHeader((String)key, (String)val));
            TraceData traceData = TraceContext.getCurrentTraceData();
            this.intercept(() -> this.interceptor.interceptRequest(traceData, newPost, this.url_, this.networkTimeout_), "Request interception error");
            int executionTimeout = ContextUtils.getExecutionTimeout(traceData.getClientSpan(), this.networkTimeout_);
            RequestConfig activeRequestConfig = RequestConfig.custom().setConnectTimeout(this.getConnectionTimeout(executionTimeout)).setSocketTimeout(this.getSocketTimeout(executionTimeout)).build();
            post.setConfig(activeRequestConfig);
            post.setEntity(new ByteArrayEntity(data));
            HttpResponse response = this.client.execute(this.host, post);
            this.intercept(() -> this.interceptor.interceptResponse(traceData, response, new Object[0]), "Response interception error");
            is = response.getEntity().getContent();
            byte[] buf = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int len = 0;
            do {
                if ((len = is.read(buf)) <= 0) continue;
                baos.write(buf, 0, len);
            } while (-1 != len);
            try {
                THttpClient.consume(response.getEntity());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream_ = new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ioe) {
            if (null != post) {
                post.abort();
            }
            throw new TTransportException(ioe);
        }
        finally {
            this.resetConsumedMessageSize(-1L);
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    throw new TTransportException(ioe);
                }
            }
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    private int getConnectionTimeout(int executionTimeout) {
        return BigDecimal.valueOf(executionTimeout).multiply(BigDecimal.valueOf(0.05)).min(BigDecimal.valueOf(this.maxConnectTimeout_)).max(BigDecimal.valueOf(1L)).intValue();
    }

    private int getSocketTimeout(int executionTimeout) {
        return Math.max(executionTimeout - this.getConnectionTimeout(executionTimeout), -1);
    }

    @Override
    public void flush() throws TTransportException {
        if (null != this.client) {
            this.flushUsingHttpClient();
            return;
        }
        byte[] data = this.requestBuffer_.toByteArray();
        this.requestBuffer_.reset();
        try {
            int socketTimeout;
            HttpURLConnection connection = (HttpURLConnection)this.url_.openConnection();
            connection.setRequestMethod("POST");
            this.setMainHeaders((key, val) -> connection.setRequestProperty((String)key, (String)val));
            this.setCustomHeaders((String key, String val) -> connection.setRequestProperty((String)key, (String)val));
            TraceData traceData = TraceContext.getCurrentTraceData();
            this.intercept(() -> this.interceptor.interceptRequest(traceData, connection, this.url_, this.networkTimeout_), "Request interception error");
            int executionTimeout = ContextUtils.getExecutionTimeout(traceData.getClientSpan(), this.networkTimeout_);
            int connectionTimeout = this.getConnectionTimeout(executionTimeout);
            if (connectionTimeout > 0) {
                connection.setConnectTimeout(connectionTimeout);
            }
            if ((socketTimeout = this.getSocketTimeout(executionTimeout)) > 0) {
                connection.setReadTimeout(socketTimeout);
            }
            connection.setDoOutput(true);
            connection.connect();
            connection.getOutputStream().write(data);
            this.intercept(() -> this.interceptor.interceptResponse(traceData, connection, new Object[0]), "Response interception error");
            this.inputStream_ = connection.getInputStream();
        }
        catch (IOException iox) {
            throw new TTransportException(iox);
        }
        finally {
            this.resetConsumedMessageSize(-1L);
        }
    }

    public static class Factory
    extends TTransportFactory {
        private final String url;
        private final HttpClient client;
        private final CommonInterceptor interceptor;

        public Factory(String url) {
            this(url, (HttpClient)null);
        }

        public Factory(String url, CommonInterceptor interceptor) {
            this(url, null, interceptor);
        }

        public Factory(String url, HttpClient client) {
            this(url, client, null);
        }

        public Factory(String url, HttpClient client, CommonInterceptor interceptor) {
            this.url = url;
            this.client = client;
            this.interceptor = interceptor;
        }

        @Override
        public TTransport getTransport(TTransport trans) {
            try {
                if (null != this.client) {
                    return new THttpClient(trans.getConfiguration(), this.url, this.client, this.interceptor);
                }
                return new THttpClient(trans.getConfiguration(), this.url, null, this.interceptor);
            }
            catch (TTransportException tte) {
                return null;
            }
        }
    }
}

