/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http.interceptor.ext;

import dev.vality.woody.api.interceptor.ext.ExtensionContext;
import dev.vality.woody.api.trace.ContextUtils;
import dev.vality.woody.api.trace.TraceData;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;

public class THCExtensionContext
extends ExtensionContext {
    private static final int REQ_URL_CONNECTION_TYPE = 1;
    private static final int REQ_HTTP_CLIENT_TYPE = 2;
    private static final int RESP_URL_CONNECTION_TYPE = 3;
    private static final int RESP_HTTP_CLIENT_TYPE = 4;
    private int reqContextType = 0;
    private int respContextType = 0;

    public THCExtensionContext(TraceData traceData, Object providerContext, Object[] contextParameters) {
        super(traceData, providerContext, contextParameters);
    }

    public void setRequestHeader(String key, String value) {
        Object providerContext = this.getProviderContext();
        switch (this.getRequestContextType(providerContext)) {
            case 1: {
                ((HttpURLConnection)providerContext).setRequestProperty(key, value);
                break;
            }
            case 2: {
                ((HttpRequestBase)providerContext).setHeader(key, value);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type:" + providerContext.getClass());
            }
        }
    }

    public String getResponseHeader(String key) {
        Object providerContext = this.getProviderContext();
        switch (this.getResponseContextType(providerContext)) {
            case 3: {
                return ((HttpURLConnection)providerContext).getHeaderField(key);
            }
            case 4: {
                Header header = ((HttpResponse)providerContext).getLastHeader(key);
                return header == null ? null : header.getValue();
            }
        }
        throw new RuntimeException("Unknown type:" + providerContext.getClass());
    }

    public Collection<String> getResponseHeaderKeys() {
        Object providerContext = this.getProviderContext();
        switch (this.getResponseContextType(providerContext)) {
            case 3: {
                return ((HttpURLConnection)providerContext).getHeaderFields().keySet();
            }
            case 4: {
                return Arrays.stream(((HttpResponse)providerContext).getAllHeaders()).map(header -> header.getName()).collect(Collectors.toSet());
            }
        }
        throw new RuntimeException("Unknown type:" + providerContext.getClass());
    }

    public int getResponseStatus() {
        Object providerContext = this.getProviderContext();
        try {
            switch (this.getResponseContextType(providerContext)) {
                case 3: {
                    return ((HttpURLConnection)providerContext).getResponseCode();
                }
                case 4: {
                    return ((HttpResponse)providerContext).getStatusLine().getStatusCode();
                }
            }
            throw new RuntimeException("Unknown type:" + providerContext.getClass());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getResponseMessage() {
        Object providerContext = this.getProviderContext();
        try {
            switch (this.getResponseContextType(providerContext)) {
                case 3: {
                    return ((HttpURLConnection)providerContext).getResponseMessage();
                }
                case 4: {
                    return ((HttpResponse)providerContext).getStatusLine().getReasonPhrase();
                }
            }
            throw new RuntimeException("Unknown type:" + providerContext.getClass());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getRequestCallEndpoint() {
        Object providerContext = this.getProviderContext();
        switch (this.getRequestContextType(providerContext)) {
            case 1: {
                return ((HttpURLConnection)providerContext).getURL();
            }
            case 2: {
                return ContextUtils.getContextValue(URL.class, this.getContextParameters(), 0);
            }
        }
        throw new RuntimeException("Unknown type:" + providerContext.getClass());
    }

    private int getRequestContextType(Object providerContext) {
        if (this.reqContextType == 0) {
            this.reqContextType = providerContext instanceof HttpRequestBase ? 2 : (providerContext instanceof HttpURLConnection ? 1 : -1);
        }
        return this.reqContextType;
    }

    private int getResponseContextType(Object providerContext) {
        if (this.respContextType == 0) {
            this.respContextType = providerContext instanceof HttpResponse ? 4 : (providerContext instanceof HttpURLConnection ? 3 : -1);
        }
        return this.respContextType;
    }
}

