/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http.event;

import dev.vality.woody.api.event.ServiceEventListener;
import dev.vality.woody.thrift.impl.http.event.THServiceEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceEventLogListener
implements ServiceEventListener<THServiceEvent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void notifyEvent(THServiceEvent event) {
        try {
            switch (event.getEventType()) {
                case SERVICE_RECEIVE: {
                    HttpServletRequest request = event.getTransportRequest();
                    if (request == null) break;
                    this.log.info("SERVER Event: {}, {}", (Object)event.getEventType(), (Object)this.buildRequestLog(request));
                    break;
                }
                case SERVICE_RESULT: {
                    HttpServletResponse response = event.getTransportResponse();
                    if (response == null) break;
                    this.log.info("SERVER Event: {}, {}", (Object)event.getEventType(), (Object)this.buildResponseLog(response));
                }
            }
        }
        catch (Exception e) {
            this.log.error("Failed to process event", e);
        }
    }

    private String buildRequestLog(HttpServletRequest httpRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpRequest:").append(httpRequest.getMethod()).append(" ").append(httpRequest.getProtocol()).append(", RemoteHost: ").append(httpRequest.getRemoteHost()).append(", Headers:");
        Enumeration headers = httpRequest.getHeaderNames();
        sb.append('[');
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            Enumeration vals = httpRequest.getHeaders(headerName);
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                sb.append(headerName).append(": ").append(val);
                if (!vals.hasMoreElements()) continue;
                sb.append(", ");
            }
            if (!headers.hasMoreElements()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    private String buildResponseLog(HttpServletResponse httpResponse) {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpResponse:").append(httpResponse.getStatus()).append(", Headers:");
        Collection headers = httpResponse.getHeaderNames();
        sb.append('[');
        Iterator it = headers.iterator();
        while (it.hasNext()) {
            String header = (String)it.next();
            sb.append(header).append(": ").append(httpResponse.getHeader(header));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }
}

