/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http.event;

import dev.vality.woody.api.event.ClientEventListener;
import dev.vality.woody.thrift.impl.http.event.THClientEvent;
import java.util.Arrays;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientEventLogListener
implements ClientEventListener<THClientEvent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void notifyEvent(THClientEvent event) {
        try {
            switch (event.getEventType()) {
                case CLIENT_SEND: {
                    HttpRequestBase httpRequest = event.getTransportRequest();
                    if (httpRequest == null) break;
                    this.log.info("CLIENT Event: {}, {}", (Object)event.getEventType(), (Object)this.buildRequestLog(httpRequest));
                    break;
                }
                case CLIENT_RECEIVE: {
                    HttpResponse httpResponse = event.getTransportResponse();
                    if (httpResponse == null) break;
                    this.log.info("CLIENT Event: {}, {}", (Object)event.getEventType(), (Object)this.buildResponseLog(httpResponse));
                }
            }
        }
        catch (Exception e) {
            this.log.error("Event processing failed", e);
        }
    }

    private String buildRequestLog(HttpRequestBase requestBase) {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpRequest:").append(requestBase.toString()).append(", Headers:").append(Arrays.toString(requestBase.getAllHeaders()));
        return sb.toString();
    }

    private String buildResponseLog(HttpResponse httpResponse) {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpResponse:").append(httpResponse.getStatusLine().toString()).append(", Headers:").append(Arrays.toString(httpResponse.getAllHeaders()));
        return sb.toString();
    }
}

