/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.proxy;

import dev.vality.woody.api.proxy.InvocationTargetProvider;
import dev.vality.woody.api.proxy.MethodCallInterceptors;
import dev.vality.woody.api.proxy.MethodCallerFactory;
import dev.vality.woody.api.proxy.MethodShadow;
import dev.vality.woody.api.proxy.ProxyInvocationHandler;
import dev.vality.woody.api.proxy.ReflectionMethodCallerFactory;
import dev.vality.woody.api.proxy.tracer.MethodCallTracer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;

public class ProxyFactory {
    private final Object object = new Object();
    private final MethodCallerFactory callerFactory;
    private final MethodCallTracer callTracer;
    private final boolean allowObjectOverriding;

    public ProxyFactory(MethodCallTracer callTracer, boolean allowObjectOverriding) {
        this(new ReflectionMethodCallerFactory(), callTracer, allowObjectOverriding);
    }

    public ProxyFactory(MethodCallerFactory callerFactory, MethodCallTracer callTracer, boolean allowObjectOverriding) {
        this.callerFactory = callerFactory;
        this.callTracer = callTracer;
        this.allowObjectOverriding = allowObjectOverriding;
    }

    public <T> T getInstance(Class<T> iface, InvocationTargetProvider<T> targetProvider) {
        return this.getInstance(iface, targetProvider, this.callerFactory, this.callTracer, this.allowObjectOverriding);
    }

    public <T> T getInstance(Class<T> iface, InvocationTargetProvider<T> targetProvider, MethodCallerFactory callerFactory, MethodCallTracer callTracer, boolean allowObjectOverriding) {
        Object[] overriden;
        if (!allowObjectOverriding && (overriden = MethodShadow.getShadowedMethods(this.object, iface)).length != 0) {
            throw new IllegalArgumentException("Target interface " + iface.getName() + "shadows Object methods:" + Arrays.toString(overriden));
        }
        return this.makeProxy(iface, targetProvider, callerFactory, callTracer);
    }

    protected <T> T makeProxy(Class<T> iface, InvocationTargetProvider<T> targetProvider, MethodCallerFactory callerFactory, MethodCallTracer callTracer) {
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)new ProxyInvocationHandler(iface, targetProvider, callerFactory, MethodCallInterceptors.trackedCallInterceptor(callTracer)));
    }
}

