/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.flow.concurrent;

import dev.vality.woody.api.flow.WFlow;
import dev.vality.woody.api.flow.concurrent.WCallable;
import dev.vality.woody.api.flow.concurrent.WRunnable;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class WExecutorService
implements ExecutorService,
Closeable {
    private final ExecutorService wrappedExecutor;

    public WExecutorService(ExecutorService wrappedExecutor) {
        this.wrappedExecutor = wrappedExecutor;
    }

    @Override
    public void execute(Runnable arg0) {
        WRunnable wRunnable = WFlow.create(arg0);
        this.wrappedExecutor.execute(wRunnable);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.wrappedExecutor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0) throws InterruptedException {
        return this.wrappedExecutor.invokeAll(this.buildWCollection(arg0));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException {
        return this.wrappedExecutor.invokeAll(this.buildWCollection(arg0), arg1, arg2);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> arg0) throws InterruptedException, ExecutionException {
        return this.wrappedExecutor.invokeAny(this.buildWCollection(arg0));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> arg0, long arg1, TimeUnit arg2) throws InterruptedException, ExecutionException, TimeoutException {
        return this.wrappedExecutor.invokeAny(this.buildWCollection(arg0), arg1, arg2);
    }

    @Override
    public boolean isShutdown() {
        return this.wrappedExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.wrappedExecutor.isTerminated();
    }

    @Override
    public void shutdown() {
        this.wrappedExecutor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.wrappedExecutor.shutdownNow();
    }

    @Override
    public <T> Future<T> submit(Callable<T> arg0) {
        WCallable<T> wCallable = WFlow.create(arg0);
        return this.wrappedExecutor.submit(wCallable);
    }

    @Override
    public Future<?> submit(Runnable arg0) {
        WRunnable wRunnable = WFlow.create(arg0);
        return this.wrappedExecutor.submit(wRunnable);
    }

    @Override
    public <T> Future<T> submit(Runnable arg0, T arg1) {
        WRunnable wRunnable = WFlow.create(arg0);
        return this.wrappedExecutor.submit(wRunnable, arg1);
    }

    private <T> Collection<? extends Callable<T>> buildWCollection(Collection<? extends Callable<T>> originalCollection) {
        ArrayList<WCallable<T>> collection = new ArrayList<WCallable<T>>();
        for (Callable<T> t : originalCollection) {
            collection.add(WFlow.create(t));
        }
        return collection;
    }

    @Override
    public void close() {
        this.shutdown();
    }
}

