/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http;

import dev.vality.woody.api.interceptor.CommonInterceptor;
import dev.vality.woody.api.trace.context.TraceContext;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolDecorator;

public class THSProtocolWrapper
extends TProtocolDecorator {
    private final boolean isCLient;
    private final CommonInterceptor interceptor;
    private final TProtocol protocol;

    public THSProtocolWrapper(TProtocol protocol, CommonInterceptor interceptor, boolean isCLient) {
        super(protocol);
        this.protocol = protocol;
        this.interceptor = interceptor;
        this.isCLient = isCLient;
    }

    public TProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        TMessage tMessage = super.readMessageBegin();
        if (this.isCLient) {
            this.interceptor.interceptResponse(TraceContext.getCurrentTraceData(), tMessage, new Object[0]);
        } else {
            this.interceptor.interceptRequest(TraceContext.getCurrentTraceData(), tMessage, new Object[0]);
        }
        return tMessage;
    }

    @Override
    public void writeMessageBegin(TMessage tMessage) throws TException {
        if (this.isCLient) {
            this.interceptor.interceptRequest(TraceContext.getCurrentTraceData(), tMessage, new Object[0]);
        } else {
            this.interceptor.interceptResponse(TraceContext.getCurrentTraceData(), tMessage, new Object[0]);
        }
        super.writeMessageBegin(tMessage);
    }
}

