/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.generator;

import dev.vality.woody.api.generator.IdGenerator;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeIdGenerator
implements IdGenerator {
    public static final String DEFAULT_SUFFIX = "";
    public static final long EPOCH_OFFSET = LocalDateTime.of(2012, 1, 1, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli();
    private static final int MAX_ID_LENGTH = 32;
    private static final int MAX_GENERATED_ID_LENGTH = 19;
    private static final Pattern ID_PATTERN = Pattern.compile("[a-zA-Z0-9.,_-]*");
    private static final int SEQUENCE_BITS = 12;
    private static final int NODE_ID_BITS = 10;
    private static final long SEQUENCE_MASK = 4095L;
    private static final int NODE_ID_MASK = 1023;
    private static final int NODE_ID_SHIFT = 12;
    private static final int TIMESTAMP_SHIFT = 22;
    private static final int MAX_ADDITIVE_LENGTH = 13;
    private static final Logger log = LoggerFactory.getLogger(SnowflakeIdGenerator.class);
    private final long nodeId;
    private final AtomicInteger sequence = new AtomicInteger();
    private final String suffix;

    public SnowflakeIdGenerator() {
        this(DEFAULT_SUFFIX);
    }

    public SnowflakeIdGenerator(long nodeId) {
        this(DEFAULT_SUFFIX, nodeId);
    }

    public SnowflakeIdGenerator(String suffix) {
        this.checkSuffix(suffix);
        this.suffix = suffix;
        this.nodeId = this.narrowNodeId(this.generateNodeId(), 1023);
    }

    public SnowflakeIdGenerator(String suffix, long nodeId) {
        this.checkSuffix(suffix);
        this.suffix = suffix;
        this.nodeId = this.narrowNodeId(nodeId >= 0L ? nodeId : this.generateNodeId(), 1023);
    }

    @Override
    public String generateId() {
        return this.nextId(this.generateTimestamp()) + this.suffix;
    }

    @Override
    public String generateId(String prefix) {
        this.checkPrefix(prefix);
        return prefix + this.nextId(this.generateTimestamp()) + this.suffix;
    }

    @Override
    public String generateId(String prefix, int counter) {
        return this.generateId(prefix);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    protected String encodeId(long id) {
        return Long.toString(id);
    }

    protected long generateTimestamp() {
        return System.currentTimeMillis();
    }

    private void checkSuffix(String suffix) {
        this.checkAdditive(suffix, 13);
    }

    private void checkPrefix(String prefix) {
        this.checkAdditive(prefix, 13 - this.suffix.length());
    }

    private void checkAdditive(String part, int maxLength) {
        if (part == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        if (part.length() > maxLength) {
            throw new IllegalArgumentException("Value to long");
        }
        if (!ID_PATTERN.matcher(part).matches()) {
            throw new IllegalArgumentException("Unrecognized symbols in value");
        }
    }

    private String nextId(long timestamp) {
        long seq = this.sequence.getAndAccumulate(1, (prev, x) -> (long)(prev + x) >= 4095L ? 0 : prev + x);
        long id = timestamp - EPOCH_OFFSET << 22 | this.nodeId << 12 | seq & 0xFFFL;
        return this.encodeId(id);
    }

    private long generateNodeId() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network != null) {
                int hash = Arrays.hashCode(network.getHardwareAddress());
                return (hash ^ hash >> 16) & 0xFFFF;
            }
        }
        catch (SocketException | UnknownHostException ex) {
            log.debug("Failed generate node id from mac address", ex);
        }
        return 0L;
    }

    private long narrowNodeId(long nodeId, int maxNodeId) {
        return nodeId < (long)maxNodeId ? nodeId : (long)maxNodeId;
    }
}

