/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http.interceptor.ext;

import dev.vality.woody.api.event.CallType;
import dev.vality.woody.api.interceptor.ext.ExtensionBundle;
import dev.vality.woody.api.trace.Metadata;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.thrift.protocol.TMessage;

public class MessageExtensionBundles {
    public static final ExtensionBundle CALL_INFO_INJECTION_BUNDLE = ExtensionBundle.createExtBundle(ExtensionBundle.ContextBundle.createCtxBundle(reqCtx -> {
        TMessage tMessage = (TMessage)reqCtx.getProviderContext();
        Metadata metadata = reqCtx.getTraceData().getClientSpan().getMetadata();
        metadata.putValue("md_call_name", tMessage.name);
        metadata.putValue("md_call_type", (Object)(tMessage.type == 4 ? CallType.CAST : CallType.CALL));
        metadata.putValue("md_thrift_http_call_msg_type", tMessage.type);
    }, respCtx -> {
        TMessage tMessage = (TMessage)respCtx.getProviderContext();
        Metadata metadata = respCtx.getTraceData().getClientSpan().getMetadata();
        metadata.putValue("md_thrift_http_call_result_msg_type", tMessage.type);
        metadata.putValue("md_request_processed", true);
    }));
    private static final List<ExtensionBundle> bundleList = Collections.unmodifiableList(Arrays.asList(CALL_INFO_INJECTION_BUNDLE));

    public static List<ExtensionBundle> getClientExtensions() {
        return bundleList;
    }

    public static List<ExtensionBundle> getServiceExtensions() {
        return bundleList;
    }

    public static List<ExtensionBundle> getExtensions(boolean isClient) {
        return isClient ? MessageExtensionBundles.getClientExtensions() : MessageExtensionBundles.getServiceExtensions();
    }
}

