/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.interceptor;

import dev.vality.woody.api.interceptor.CommonInterceptor;
import dev.vality.woody.api.interceptor.EmptyCommonInterceptor;
import dev.vality.woody.api.trace.ContextUtils;
import dev.vality.woody.api.trace.TraceData;
import dev.vality.woody.api.trace.context.TraceContext;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextInterceptor
implements CommonInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ContextInterceptor.class);
    private final TraceContext traceContext;
    private final CommonInterceptor interceptor;

    public ContextInterceptor(TraceContext traceContext, CommonInterceptor interceptor) {
        this.traceContext = Objects.requireNonNull(traceContext, "TraceContext can't be null");
        this.interceptor = interceptor != null ? interceptor : new EmptyCommonInterceptor();
    }

    @Override
    public boolean interceptRequest(TraceData traceData, Object providerContext, Object ... contextParams) {
        LOG.trace("Intercept request context");
        if (!TraceContext.getCurrentTraceData().getServiceSpan().isFilled()) {
            throw new IllegalStateException("TraceContext service span must be filled");
        }
        this.traceContext.init();
        return this.interceptor.interceptRequest(traceData, providerContext, contextParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean interceptResponse(TraceData traceData, Object providerContext, Object ... contextParams) {
        LOG.trace("Intercept response context");
        try {
            boolean bl = this.interceptor.interceptResponse(traceData, providerContext, contextParams);
            return bl;
        }
        finally {
            this.traceContext.destroy(ContextUtils.hasCallErrors(traceData.getActiveSpan()));
        }
    }
}

