/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http.interceptor.ext;

import dev.vality.woody.api.interceptor.ext.ExtensionBundle;
import dev.vality.woody.api.trace.Metadata;
import dev.vality.woody.api.trace.context.metadata.MetadataConversionException;
import dev.vality.woody.api.trace.context.metadata.MetadataExtensionKit;
import dev.vality.woody.thrift.impl.http.interceptor.THRequestInterceptionException;
import dev.vality.woody.thrift.impl.http.transport.THttpHeader;
import dev.vality.woody.thrift.impl.http.transport.TTransportErrorType;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class MetadataExtensionBundle
extends ExtensionBundle {
    private static final Pattern KEY_PATTERN = Pattern.compile("[\\w-.]{1,53}");

    public MetadataExtensionBundle(List<MetadataExtensionKit> extensionList) {
        super(MetadataExtensionBundle.createClientBundle(extensionList), MetadataExtensionBundle.createServiceBundle(extensionList));
    }

    private static ExtensionBundle.ContextBundle createClientBundle(List<MetadataExtensionKit> extensionKits) {
        return ExtensionBundle.ContextBundle.createCtxBundle(reqCCtx -> {
            Metadata customMetadata = reqCCtx.getTraceData().getActiveSpan().getCustomMetadata();
            LinkedHashSet unusedKits = new LinkedHashSet(extensionKits);
            for (String key : customMetadata.getKeys()) {
                if (KEY_PATTERN.matcher(key).matches()) {
                    boolean applied = false;
                    try {
                        for (MetadataExtensionKit extKit : extensionKits) {
                            if (!(applied |= extKit.getConverter().apply(key))) continue;
                            unusedKits.remove(extKit);
                            Object metaVal = extKit.getExtension().getValue(key, customMetadata);
                            String valueString = extKit.getConverter().convertToString(key, metaVal);
                            reqCCtx.setRequestHeader(MetadataExtensionBundle.formatHeaderKey(key), valueString);
                            break;
                        }
                    }
                    catch (MetadataConversionException e) {
                        throw new THRequestInterceptionException(TTransportErrorType.BAD_HEADER, key, e);
                    }
                    if (applied) continue;
                    String valueString = String.valueOf(customMetadata.getValue(key));
                    reqCCtx.setRequestHeader(MetadataExtensionBundle.formatHeaderKey(key), valueString);
                    continue;
                }
                throw new THRequestInterceptionException(TTransportErrorType.BAD_HEADER, key);
            }
            for (MetadataExtensionKit extKit : unusedKits) {
                if (extKit.getConverter().applyToString()) continue;
                throw new THRequestInterceptionException(TTransportErrorType.BAD_HEADER, extKit.getConverter().getClass().getName() + " request not applied");
            }
        }, respCCtx -> {});
    }

    private static ExtensionBundle.ContextBundle createServiceBundle(List<MetadataExtensionKit> extensionKits) {
        return ExtensionBundle.ContextBundle.createCtxBundle(reqSCtx -> {
            HttpServletRequest request = reqSCtx.getProviderRequest();
            LinkedHashSet unusedKits = new LinkedHashSet(extensionKits);
            Enumeration headerKeys = request.getHeaderNames();
            Metadata customMetaData = reqSCtx.getTraceData().getActiveSpan().getCustomMetadata();
            while (headerKeys.hasMoreElements()) {
                String headerKey = (String)headerKeys.nextElement();
                String metaKey = MetadataExtensionBundle.formatMetaKey(headerKey);
                if (metaKey == null || customMetaData.containsKey(metaKey)) continue;
                boolean applied = false;
                String metaStrVal = request.getHeader(headerKey);
                try {
                    for (MetadataExtensionKit extKit : extensionKits) {
                        if (!(applied |= extKit.getConverter().apply(metaKey))) continue;
                        unusedKits.remove(extKit);
                        Object metaVal = extKit.getConverter().convertToObject(metaKey, metaStrVal);
                        extKit.getExtension().setValue(metaKey, metaVal, customMetaData);
                        break;
                    }
                }
                catch (MetadataConversionException e) {
                    throw new THRequestInterceptionException(TTransportErrorType.BAD_HEADER, headerKey, e);
                }
                if (applied) continue;
                customMetaData.putValue(metaKey, metaStrVal);
            }
            for (MetadataExtensionKit extKit : unusedKits) {
                if (extKit.getConverter().applyToString()) continue;
                throw new THRequestInterceptionException(TTransportErrorType.BAD_HEADER, extKit.getConverter().getClass().getName() + "response not applied");
            }
        }, respSCtx -> {});
    }

    private static String formatHeaderKey(String metaKey) {
        return THttpHeader.META.getKey() + metaKey.toLowerCase();
    }

    private static String formatMetaKey(String headerKey) {
        String keyPrefix = THttpHeader.META.getKey();
        return headerKey.startsWith(keyPrefix) ? headerKey.substring(keyPrefix.length()).toLowerCase() : null;
    }
}

