/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Stream;

public class MethodShadow {
    public static final Comparator<Method> METHOD_COMPARATOR = (m1, m2) -> {
        int currResult = m1.getName().compareTo(m2.getName());
        if (currResult != 0) {
            return currResult;
        }
        currResult = m1.getParameterCount() - m2.getParameterCount();
        if (currResult != 0) {
            return currResult;
        }
        Class<?>[] pt1 = m1.getParameterTypes();
        Class<?>[] pt2 = m2.getParameterTypes();
        for (int i = 0; i < pt1.length; ++i) {
            if (pt1[i] == pt2[i]) continue;
            return pt1[i].hashCode() - pt2[i].hashCode();
        }
        return 0;
    };

    public static Method[] getShadowedIfaceMethods(Class ifaceA, Class ifaceB) {
        Stream.of(ifaceA, ifaceB).forEach(iface -> MethodShadow.checkInterface(iface, "Referred class is not an interface:"));
        return MethodShadow.getOverlappingMethods(ifaceA.getMethods(), ifaceB.getMethods());
    }

    public static Method[] getShadowedMethods(Class ifaceA, Collection<Class> ifacesB) {
        for (Class ifaceB : ifacesB) {
            Method[] shadowedMethods = MethodShadow.getShadowedIfaceMethods(ifaceA, ifaceB);
            if (shadowedMethods.length == 0) continue;
            return shadowedMethods;
        }
        return new Method[0];
    }

    public static Method[] getShadowedMethods(Object object, Class iface) {
        return MethodShadow.getShadowedMethods(object.getClass(), iface);
    }

    public static Method[] getShadowedMethods(Class objClass, Class iface) {
        MethodShadow.checkInterface(iface, "Referred class is not an interface:");
        Method[] objMethods = (Method[])Arrays.stream(objClass.getMethods()).filter(m -> {
            int mod = m.getModifiers();
            return !Modifier.isPrivate(mod);
        }).toArray(Method[]::new);
        return MethodShadow.getOverlappingMethods(objMethods, iface.getMethods());
    }

    public static boolean isSameSignature(Method methodA, Method methodB) {
        return METHOD_COMPARATOR.compare(methodA, methodB) == 0;
    }

    public static Method[] getOverlappingMethods(Method[] methodsA, Method[] methodsB) {
        return (Method[])Arrays.stream(methodsA).filter(tm -> Arrays.stream(methodsB).anyMatch(sm -> MethodShadow.isSameSignature(tm, sm))).toArray(Method[]::new);
    }

    public static Method getSameMethod(Method searchMethod, Class targetClass) {
        try {
            return targetClass.getMethod(searchMethod.getName(), searchMethod.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static void checkInterface(Class cl, String errorMessage) {
        if (!cl.isInterface()) {
            throw new IllegalArgumentException(errorMessage + cl.getName());
        }
    }
}

