/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http.event;

import dev.vality.woody.api.event.ClientEventListener;
import dev.vality.woody.api.flow.error.WErrorDefinition;
import dev.vality.woody.thrift.impl.http.event.THClientEvent;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientEventLogListener
implements ClientEventListener<THClientEvent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void notifyEvent(THClientEvent event) {
        try {
            switch (event.getEventType()) {
                case CALL_SERVICE: {
                    this.log.info("CLIENT Event: {}, [{}, Type: {}], Time: {}", new Object[]{event.getEventType(), event.getCallName(), event.getCallType(), event.getTimeStamp()});
                    break;
                }
                case CLIENT_SEND: {
                    this.log.info("CLIENT Event: {}, Url: {}, Time: {}", new Object[]{event.getEventType(), event.getEndpoint().getStringValue(), event.getTimeStamp()});
                    break;
                }
                case CLIENT_RECEIVE: {
                    this.log.info("CLIENT Event: {}, Status: {}, Time: {}", new Object[]{event.getEventType(), event.isSuccessfulCall() ? "ok" : "error", event.getTimeStamp()});
                    break;
                }
                case SERVICE_RESULT: {
                    this.log.info("CLIENT Event: {}, Status: {}, Time: {}, Duration: {}", new Object[]{event.getEventType(), event.isSuccessfulCall() ? "ok" : "error", event.getTimeStamp(), event.getDuration()});
                    break;
                }
                case ERROR: {
                    this.log.info("CLIENT Event: {}, ErrType: {}, TErrType: {}, ErrName: {},  Time: {}, Duration: {}", new Object[]{event.getEventType(), event.getErrorDefinition(), event.getThriftErrorType(), Optional.ofNullable(event.getErrorDefinition()).map(WErrorDefinition::getErrorName).orElse(""), event.getTimeStamp(), event.getDuration()});
                    break;
                }
                default: {
                    this.log.info("CLIENT Unknown error: {}", (Object)event);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.log.error("Event processing failed", e);
        }
    }
}

