/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.flow.concurrent;

import dev.vality.woody.api.MDCUtils;
import dev.vality.woody.api.trace.TraceData;
import dev.vality.woody.api.trace.context.TraceContext;
import java.util.concurrent.Callable;

public class WCallable<T>
implements Callable<T> {
    private final TraceData traceData;
    private final Callable<T> wrappedCallable;

    public Callable<T> getWrappedCallable() {
        return this.wrappedCallable;
    }

    public TraceData getTraceData() {
        return this.traceData;
    }

    public WCallable(Callable<T> wrappedCallable, TraceData traceData) {
        if (wrappedCallable == null || traceData == null) {
            throw new NullPointerException("Null arguments're not allowed");
        }
        this.traceData = traceData;
        this.wrappedCallable = wrappedCallable;
    }

    @Override
    public T call() throws Exception {
        TraceData originalTraceData = TraceContext.getCurrentTraceData();
        TraceContext.setCurrentTraceData(this.getTraceData().cloneObject());
        if (this.traceData != originalTraceData) {
            MDCUtils.putSpanData(this.traceData.getActiveSpan().getSpan());
        }
        try {
            T t = this.getWrappedCallable().call();
            return t;
        }
        finally {
            TraceContext.setCurrentTraceData(originalTraceData);
            MDCUtils.putSpanData(originalTraceData.getActiveSpan().getSpan());
        }
    }
}

