/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api;

import dev.vality.woody.api.ServiceBuilder;
import dev.vality.woody.api.WoodyInstantiationException;
import dev.vality.woody.api.event.ServiceEventListener;
import dev.vality.woody.api.proxy.ProxyFactory;
import dev.vality.woody.api.proxy.SingleTargetProvider;
import dev.vality.woody.api.proxy.tracer.CompositeTracer;
import dev.vality.woody.api.proxy.tracer.DeadlineTracer;
import dev.vality.woody.api.proxy.tracer.EventTracer;
import dev.vality.woody.api.proxy.tracer.MethodCallTracer;
import dev.vality.woody.api.proxy.tracer.TargetCallTracer;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractServiceBuilder<Srv>
implements ServiceBuilder<Srv> {
    protected static final ServiceEventListener DEFAULT_EVENT_LISTENER = event -> {};
    private boolean allowObjectProxyOverriding = false;
    private ServiceEventListener eventListener = DEFAULT_EVENT_LISTENER;
    private final AtomicBoolean used = new AtomicBoolean(false);

    @Override
    public ServiceBuilder withEventListener(ServiceEventListener listener) {
        this.eventListener = listener;
        return this;
    }

    @Override
    public <T> Srv build(Class<T> iface, T serviceHandler) {
        if (!this.used.compareAndSet(false, true)) {
            throw new IllegalStateException("Builder already used");
        }
        try {
            T target = this.createProxyService(iface, serviceHandler);
            return this.createProviderService(iface, target);
        }
        catch (Exception e) {
            throw new WoodyInstantiationException(e);
        }
    }

    @Override
    public ServiceEventListener getEventListener() {
        return this.eventListener;
    }

    protected <T> T createProxyService(Class<T> iface, T handler) {
        ProxyFactory proxyFactory = new ProxyFactory(this.createEventTracer(), this.allowObjectProxyOverriding);
        return proxyFactory.getInstance(iface, new SingleTargetProvider<T>(iface, handler));
    }

    protected MethodCallTracer createEventTracer() {
        return new CompositeTracer(TargetCallTracer.forServer(), DeadlineTracer.forService(), new EventTracer(this.getOnCallStartEventListener(), this.getOnCallEndEventListener(), this.getErrorListener()));
    }

    public void setAllowObjectProxyOverriding(boolean allowObjectProxyOverriding) {
        this.allowObjectProxyOverriding = allowObjectProxyOverriding;
    }

    protected abstract Runnable getErrorListener();

    protected abstract Runnable getOnCallStartEventListener();

    protected abstract Runnable getOnSendEventListener();

    protected abstract Runnable getOnReceiveEventListener();

    protected abstract Runnable getOnCallEndEventListener();

    protected abstract <T> Srv createProviderService(Class<T> var1, T var2);
}

