/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.proxy.tracer;

import dev.vality.woody.api.flow.error.ErrorMapProcessor;
import dev.vality.woody.api.flow.error.WErrorDefinition;
import dev.vality.woody.api.proxy.InstanceMethodCaller;
import dev.vality.woody.api.proxy.tracer.EmptyTracer;
import dev.vality.woody.api.trace.ContextSpan;
import dev.vality.woody.api.trace.context.TraceContext;
import java.util.Objects;
import java.util.function.BiConsumer;

public class ErrorMappingTracer
extends EmptyTracer {
    private final ErrorMapProcessor errorProcessor;
    private final BiConsumer<WErrorDefinition, ContextSpan> errDefConsumer;

    public ErrorMappingTracer(ErrorMapProcessor errorProcessor, BiConsumer<WErrorDefinition, ContextSpan> errDefConsumer) {
        Objects.requireNonNull(errorProcessor);
        Objects.requireNonNull(errDefConsumer);
        this.errorProcessor = errorProcessor;
        this.errDefConsumer = errDefConsumer;
    }

    @Override
    public void afterCall(Object[] args, InstanceMethodCaller caller, Object result) {
        this.processCall();
    }

    @Override
    public void callError(Object[] args, InstanceMethodCaller caller, Throwable error) {
        this.processCall();
    }

    private void processCall() {
        WErrorDefinition errorDefinition = this.errorProcessor.processMapToDef(TraceContext.getCurrentTraceData());
        if (errorDefinition != null) {
            ContextSpan contextSpan = TraceContext.getCurrentTraceData().getActiveSpan();
            contextSpan.getMetadata().putValue("md_error_def", errorDefinition);
            this.errDefConsumer.accept(errorDefinition, contextSpan);
        }
    }
}

