/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.proxy.tracer;

import dev.vality.woody.api.proxy.InstanceMethodCaller;
import dev.vality.woody.api.proxy.tracer.MethodCallTracer;
import dev.vality.woody.api.trace.context.TraceContext;

public class ContextTracer
implements MethodCallTracer {
    private final TraceContext traceContext;
    private final MethodCallTracer targetTracer;

    public ContextTracer(TraceContext traceContext, MethodCallTracer targetTracer) {
        this.traceContext = traceContext;
        this.targetTracer = targetTracer;
    }

    @Override
    public void beforeCall(Object[] args, InstanceMethodCaller caller) throws Exception {
        this.traceContext.init();
        this.targetTracer.beforeCall(args, caller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCall(Object[] args, InstanceMethodCaller caller, Object result) throws Exception {
        try {
            this.targetTracer.afterCall(args, caller, result);
        }
        finally {
            this.traceContext.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callError(Object[] args, InstanceMethodCaller caller, Throwable error) throws Exception {
        try {
            this.targetTracer.callError(args, caller, error);
        }
        finally {
            this.traceContext.destroy(true);
        }
    }
}

