/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api;

import dev.vality.woody.api.ClientBuilder;
import dev.vality.woody.api.WoodyInstantiationException;
import dev.vality.woody.api.event.ClientEventListener;
import dev.vality.woody.api.flow.error.ErrorMapProcessor;
import dev.vality.woody.api.flow.error.WErrorDefinition;
import dev.vality.woody.api.generator.IdGenerator;
import dev.vality.woody.api.proxy.InvocationTargetProvider;
import dev.vality.woody.api.proxy.ProxyFactory;
import dev.vality.woody.api.proxy.SingleTargetProvider;
import dev.vality.woody.api.proxy.tracer.CompositeTracer;
import dev.vality.woody.api.proxy.tracer.ContextTracer;
import dev.vality.woody.api.proxy.tracer.DeadlineTracer;
import dev.vality.woody.api.proxy.tracer.ErrorGenTracer;
import dev.vality.woody.api.proxy.tracer.ErrorMappingTracer;
import dev.vality.woody.api.proxy.tracer.EventTracer;
import dev.vality.woody.api.proxy.tracer.MethodCallTracer;
import dev.vality.woody.api.proxy.tracer.TargetCallTracer;
import dev.vality.woody.api.trace.ContextSpan;
import dev.vality.woody.api.trace.context.TraceContext;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;

public abstract class AbstractClientBuilder
implements ClientBuilder {
    protected static final ClientEventListener DEFAULT_EVENT_LISTENER = event -> {};
    private int networkTimeout = 5000;
    private URI address;
    private IdGenerator idGenerator;
    private ClientEventListener eventListener = DEFAULT_EVENT_LISTENER;
    private boolean allowObjectProxyOverriding = false;
    private final AtomicBoolean used = new AtomicBoolean(false);

    @Override
    public ClientBuilder withNetworkTimeout(int timeout) {
        this.networkTimeout = timeout;
        return this;
    }

    @Override
    public ClientBuilder withAddress(URI address) {
        this.address = address;
        return this;
    }

    @Override
    public ClientBuilder withEventListener(ClientEventListener listener) {
        this.eventListener = listener;
        return this;
    }

    @Override
    public ClientBuilder withIdGenerator(IdGenerator generator) {
        this.idGenerator = generator;
        return this;
    }

    @Override
    public int getNetworkTimeout() {
        return this.networkTimeout;
    }

    @Override
    public URI getAddress() {
        return this.address;
    }

    @Override
    public ClientEventListener getEventListener() {
        return this.eventListener;
    }

    @Override
    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    @Override
    public <T> T build(Class<T> iface) {
        if (!this.used.compareAndSet(false, true)) {
            throw new IllegalStateException("Builder already used");
        }
        try {
            T target = this.createProviderClient(iface);
            return this.build(iface, new SingleTargetProvider<T>(iface, target));
        }
        catch (WoodyInstantiationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WoodyInstantiationException(e);
        }
    }

    protected <T> T build(Class<T> iface, InvocationTargetProvider<T> targetProvider) {
        try {
            return this.createProxyClient(iface, targetProvider);
        }
        catch (Exception e) {
            throw new WoodyInstantiationException(e);
        }
    }

    protected void setAllowObjectProxyOverriding(boolean allowObjectProxyOverriding) {
        this.allowObjectProxyOverriding = allowObjectProxyOverriding;
    }

    protected <T> T createProxyClient(Class<T> iface, InvocationTargetProvider<T> targetProvider) {
        ProxyFactory proxyFactory = new ProxyFactory(this.createCallTracer(iface, () -> {}), this.allowObjectProxyOverriding);
        return proxyFactory.getInstance(iface, targetProvider);
    }

    protected MethodCallTracer createCallTracer(Class iface, Runnable listenerStub) {
        TraceContext traceContext = this.createTraceContext();
        ErrorMapProcessor errorMapProcessor = this.createErrorMapProcessor(iface);
        BiConsumer<WErrorDefinition, ContextSpan> errDefConsumer = this.getErrorDefinitionConsumer();
        return new ContextTracer(traceContext, new CompositeTracer(TargetCallTracer.forClient(), new ErrorMappingTracer(errorMapProcessor, errDefConsumer), new EventTracer(listenerStub, this.getOnCallEndEventListener(), this.getErrorListener()), new ErrorGenTracer(errorMapProcessor), DeadlineTracer.forClient(this.getNetworkTimeout())));
    }

    protected TraceContext createTraceContext() {
        return TraceContext.forClient(this.idGenerator);
    }

    protected abstract BiConsumer<WErrorDefinition, ContextSpan> getErrorDefinitionConsumer();

    protected abstract Runnable getErrorListener();

    protected abstract Runnable getOnCallStartEventListener();

    protected abstract Runnable getOnSendEventListener();

    protected abstract Runnable getOnReceiveEventListener();

    protected abstract Runnable getOnCallEndEventListener();

    protected abstract ErrorMapProcessor createErrorMapProcessor(Class var1);

    protected abstract <T> T createProviderClient(Class<T> var1);
}

