/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http.event;

import dev.vality.woody.api.event.ClientEventListener;
import dev.vality.woody.api.trace.ContextUtils;
import dev.vality.woody.thrift.impl.http.event.THClientEvent;
import java.util.Arrays;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class THCEventLogListener
implements ClientEventListener<THClientEvent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void notifyEvent(THClientEvent event) {
        try {
            switch (event.getEventType()) {
                case CALL_SERVICE: {
                    this.log.info("CLN: {}, [{}, {}]", new Object[]{event.getEventType(), event.getCallName(), event.getCallType()});
                    break;
                }
                case CLIENT_SEND: {
                    HttpRequestBase request = event.getTransportRequest();
                    if (request == null) {
                        this.log.info("CLN: {} [no transport request]", (Object)event.getEventType());
                        break;
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info("CLN: {}, [EP: {}, Headers: {}]", new Object[]{event.getEventType(), event.getEndpoint().getStringValue(), Arrays.toString(request.getAllHeaders())});
                    }
                    break;
                }
                case CLIENT_RECEIVE: {
                    HttpResponse response = event.getTransportResponse();
                    if (response == null) {
                        this.log.info("CLN: {} [no transport response]", (Object)event.getEventType());
                        break;
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info("CLN: {}, CRes: {}, [StLine: {}, Headers: {}]", new Object[]{event.getEventType(), event.isSuccessfulCall() ? "ok" : "error", response.getStatusLine().toString(), Arrays.toString(response.getAllHeaders())});
                    }
                    break;
                }
                case SERVICE_RESULT: {
                    this.log.info("CLN: {}, CRes: {}, Time: {}ms", new Object[]{event.getEventType(), event.isSuccessfulCall() ? "ok" : "error", System.currentTimeMillis() - event.getTimeStamp()});
                    break;
                }
                case ERROR: {
                    Throwable error = ContextUtils.getCallError(event.getActiveSpan());
                    if (error == null) {
                        error = ContextUtils.getInterceptionError(event.getActiveSpan());
                    }
                    this.log.warn("CLN: {}, [ErrDef: {}, TErrType: {}], Time: {}ms", new Object[]{event.getEventType(), event.getErrorDefinition(), event.getThriftErrorType(), System.currentTimeMillis() - event.getTimeStamp(), error});
                    break;
                }
                default: {
                    this.log.info("CLN Unknown error: {}", (Object)event);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.log.error("Event processing failed", e);
        }
    }
}

