/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.proxy;

import dev.vality.woody.api.proxy.InstanceMethodCaller;
import dev.vality.woody.api.proxy.InvocationTargetProvider;
import dev.vality.woody.api.proxy.MethodCallInterceptor;
import dev.vality.woody.api.proxy.MethodCallInterceptors;
import dev.vality.woody.api.proxy.MethodCallerFactory;
import dev.vality.woody.api.proxy.MethodShadow;
import dev.vality.woody.api.proxy.SingleTargetProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;

public final class ProxyInvocationHandler
implements InvocationHandler {
    private final Map<Method, CallerBundle> callMap;
    private final InvocationTargetProvider targetProvider;

    public ProxyInvocationHandler(Class iface, InvocationTargetProvider targetProvider, MethodCallerFactory callerFactory, MethodCallInterceptor callInterceptor) {
        this.targetProvider = targetProvider;
        this.callMap = this.createCallMap(callInterceptor, targetProvider, iface, callerFactory);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        CallerBundle methodCallerBundle = this.callMap.get(method);
        if (methodCallerBundle != null) {
            return methodCallerBundle.interceptor.intercept(proxy, args, methodCallerBundle.caller);
        }
        return method.invoke(this.targetProvider.getTarget(), args);
    }

    private Map<Method, CallerBundle> createCallMap(MethodCallInterceptor callInterceptor, InvocationTargetProvider targetProvider, Class iface, MethodCallerFactory callerFactory) {
        Method[] targetIfaceMethods;
        Class targetType = targetProvider.getTargetType();
        if (!iface.isAssignableFrom(targetType)) {
            throw new IllegalArgumentException("Target object class doesn't implement referred interface");
        }
        TreeMap<Method, CallerBundle> callerMap = new TreeMap<Method, CallerBundle>(MethodShadow.METHOD_COMPARATOR);
        for (Method method : targetIfaceMethods = MethodShadow.getShadowedMethods(targetType, iface)) {
            callerMap.put(MethodShadow.getSameMethod(method, iface), new CallerBundle(callerFactory.getInstance(targetProvider, method), callInterceptor));
        }
        return this.addObjectMethods(iface, callerFactory, callerMap);
    }

    private Map<Method, CallerBundle> addObjectMethods(Class iface, MethodCallerFactory callerFactory, Map<Method, CallerBundle> callerMap) {
        SingleTargetProvider<ProxyInvocationHandler> objTargetProvider = new SingleTargetProvider<ProxyInvocationHandler>(Object.class, this);
        MethodCallInterceptor directCallInterceptor = MethodCallInterceptors.directCallInterceptor();
        BiFunction<Object, Object, Object> targetExtractor = (src, stub) -> {
            InvocationHandler invocationHandler = null;
            try {
                invocationHandler = Proxy.getInvocationHandler(src);
                if (!(invocationHandler instanceof ProxyInvocationHandler)) {
                    invocationHandler = null;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return invocationHandler == null ? stub : invocationHandler;
        };
        try {
            Method objMethod = objTargetProvider.getClass().getMethod("hashCode", new Class[0]);
            callerMap.put(objMethod, new CallerBundle(callerFactory.getInstance(objTargetProvider, objMethod, (src, args) -> targetExtractor.apply(src, this).hashCode()), directCallInterceptor));
            objMethod = objTargetProvider.getClass().getMethod("toString", new Class[0]);
            callerMap.put(objMethod, new CallerBundle(callerFactory.getInstance(objTargetProvider, objMethod, (src, args) -> iface.getName() + "@" + targetExtractor.apply(src, this).hashCode()), directCallInterceptor));
            objMethod = objTargetProvider.getClass().getMethod("equals", Object.class);
            callerMap.put(objMethod, new CallerBundle(callerFactory.getInstance(objTargetProvider, objMethod, (src, args) -> targetExtractor.apply(args[0], null) == this), directCallInterceptor));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Object methods're not found", e);
        }
        return callerMap;
    }

    private static class CallerBundle {
        private final InstanceMethodCaller caller;
        private final MethodCallInterceptor interceptor;

        public CallerBundle(InstanceMethodCaller caller, MethodCallInterceptor interceptor) {
            this.caller = caller;
            this.interceptor = interceptor;
        }
    }
}

