/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.flow.concurrent;

import dev.vality.woody.api.MDCUtils;
import dev.vality.woody.api.trace.TraceData;
import dev.vality.woody.api.trace.context.TraceContext;

public class WRunnable
implements Runnable {
    private final TraceData traceData;
    private final Runnable wrappedRunnable;

    public WRunnable(Runnable runnable, TraceData traceData) {
        if (runnable == null || traceData == null) {
            throw new NullPointerException("Null arguments're not allowed");
        }
        this.wrappedRunnable = runnable;
        this.traceData = traceData;
    }

    public Runnable geWrappedRunnable() {
        return this.wrappedRunnable;
    }

    public TraceData getTraceData() {
        return this.traceData;
    }

    @Override
    public void run() {
        TraceData originalTraceData = TraceContext.getCurrentTraceData();
        TraceContext.setCurrentTraceData(this.getTraceData().cloneObject());
        if (this.traceData != originalTraceData) {
            MDCUtils.putSpanData(this.traceData.getActiveSpan().getSpan());
        }
        try {
            this.geWrappedRunnable().run();
        }
        finally {
            TraceContext.setCurrentTraceData(originalTraceData);
            MDCUtils.putSpanData(originalTraceData.getActiveSpan().getSpan());
        }
    }
}

