/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.event;

import dev.vality.woody.api.event.CallType;
import dev.vality.woody.api.flow.error.WErrorDefinition;
import dev.vality.woody.api.trace.ContextSpan;
import dev.vality.woody.api.trace.ContextUtils;
import dev.vality.woody.api.trace.Endpoint;
import dev.vality.woody.api.trace.TraceData;

public abstract class Event {
    private final TraceData traceData;

    public Event(TraceData traceData) {
        this.traceData = traceData;
    }

    public TraceData getTraceData() {
        return this.traceData;
    }

    public Object getEventType() {
        return this.getActiveSpan().getMetadata().getValue("md_event_type");
    }

    public CallType getCallType() {
        return (CallType)((Object)this.getActiveSpan().getMetadata().getValue("md_call_type"));
    }

    public String getCallName() {
        return (String)this.getActiveSpan().getMetadata().getValue("md_call_name");
    }

    public Object[] getCallArguments() {
        return (Object[])this.getActiveSpan().getMetadata().getValue("md_call_args");
    }

    public Object getCallResult() {
        return this.getActiveSpan().getMetadata().getValue("md_call_result");
    }

    public WErrorDefinition getErrorDefinition() {
        return (WErrorDefinition)this.getActiveSpan().getMetadata().getValue("md_error_def");
    }

    public String getSpanId() {
        return this.getActiveSpan().getSpan().getId();
    }

    public String getParentId() {
        return this.getActiveSpan().getSpan().getParentId();
    }

    public String getTraceId() {
        return this.getActiveSpan().getSpan().getTraceId();
    }

    public long getTimeStamp() {
        return this.getActiveSpan().getSpan().getTimestamp();
    }

    public long getDuration() {
        return this.getActiveSpan().getSpan().getDuration();
    }

    public Endpoint getEndpoint() {
        return (Endpoint)this.getActiveSpan().getMetadata().getValue("md_call_endpoint");
    }

    public boolean isSuccessfulCall() {
        return !ContextUtils.hasCallErrors(this.getActiveSpan());
    }

    public abstract ContextSpan getActiveSpan();
}

