/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http.event;

import dev.vality.woody.api.event.ServiceEventListener;
import dev.vality.woody.api.trace.ContextUtils;
import dev.vality.woody.thrift.impl.http.event.THServiceEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class THSEventLogListener
implements ServiceEventListener<THServiceEvent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void notifyEvent(THServiceEvent event) {
        try {
            switch (event.getEventType()) {
                case CALL_HANDLER: {
                    this.log.info("SRV: {}, [{}, {}]", new Object[]{event.getEventType(), event.getCallName(), event.getCallType()});
                    break;
                }
                case HANDLER_RESULT: {
                    this.log.info("SRV: {}, CRes: {}, HTime: {}ms", new Object[]{event.getEventType(), event.isSuccessfulCall() ? "ok" : "error", System.currentTimeMillis() - event.getTimeStamp()});
                    break;
                }
                case SERVICE_RECEIVE: {
                    HttpServletRequest request = event.getTransportRequest();
                    if (request == null) {
                        this.log.info("SRV: {} [no transport request]", (Object)event.getEventType());
                        break;
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info("SRV: {}, [EP: {}, Url: {}, Src: [{}]:{}, Headers: {}]", new Object[]{event.getEventType(), event.getEndpoint().getStringValue(), this.buildUrl(request), request.getRemoteAddr(), request.getRemotePort(), this.buildHeaders(request)});
                    }
                    break;
                }
                case SERVICE_RESULT: {
                    HttpServletResponse response = event.getTransportResponse();
                    if (response == null) {
                        this.log.info("SRV: {} [no transport response]", (Object)event.getEventType());
                        break;
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info("SRV: {}, CRes: {}, [Status: {}, Headers: {}]", new Object[]{event.getEventType(), event.isSuccessfulCall() ? "ok" : "error", response.getStatus(), this.buildHeaders(response)});
                    }
                    break;
                }
                case ERROR: {
                    Throwable error = ContextUtils.getCallError(event.getActiveSpan());
                    if (error == null) {
                        error = ContextUtils.getInterceptionError(event.getActiveSpan());
                    }
                    this.log.info("SRV: {}, [ErrDef: {}, TErrType: {}], Time: {}ms", new Object[]{event.getEventType(), event.getErrorDefinition(), event.getThriftErrorType(), System.currentTimeMillis() - event.getTimeStamp(), error});
                    break;
                }
                default: {
                    this.log.info("SRV Unknown error: {}", (Object)event);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.log.error("Failed to process event", e);
        }
    }

    private String buildUrl(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString == null) {
            return requestURL.toString();
        }
        return requestURL.append('?').append(queryString).toString();
    }

    private String buildHeaders(HttpServletRequest httpRequest) {
        StringBuilder sb = new StringBuilder();
        Enumeration headers = httpRequest.getHeaderNames();
        sb.append('[');
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            Enumeration vals = httpRequest.getHeaders(headerName);
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                sb.append(headerName).append(": ").append(val);
                if (!vals.hasMoreElements()) continue;
                sb.append(", ");
            }
            if (!headers.hasMoreElements()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    private String buildHeaders(HttpServletResponse httpResponse) {
        StringBuilder sb = new StringBuilder();
        Collection headers = httpResponse.getHeaderNames();
        sb.append('[');
        Iterator it = headers.iterator();
        while (it.hasNext()) {
            String header = (String)it.next();
            sb.append(header).append(": ").append(httpResponse.getHeader(header));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }
}

