/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.thrift.impl.http.error;

import dev.vality.woody.api.flow.error.WErrorDefinition;
import dev.vality.woody.api.flow.error.WErrorMapper;
import dev.vality.woody.api.flow.error.WErrorSource;
import dev.vality.woody.api.flow.error.WErrorType;
import dev.vality.woody.api.proxy.InstanceMethodCaller;
import dev.vality.woody.api.proxy.MethodShadow;
import dev.vality.woody.api.trace.ContextSpan;
import dev.vality.woody.api.trace.ContextUtils;
import dev.vality.woody.api.trace.Metadata;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TStruct;

public class THBusinessErrorMapper
implements WErrorMapper {
    public static final UnaryOperator<String> BUSINESS_ERROR_REASON_FUNC = errName -> errName;
    private final Map<Method, Class[]> errorsMap;

    public THBusinessErrorMapper(Class iface) {
        this.errorsMap = this.getDeclaredErrorsMap(iface);
    }

    private Map<Method, Class[]> getDeclaredErrorsMap(Class iface) {
        TreeMap<Method, Class[]> errorsMap = new TreeMap<Method, Class[]>(MethodShadow.METHOD_COMPARATOR);
        Arrays.stream(iface.getMethods()).forEach(m -> errorsMap.put((Method)m, (Class[])Arrays.stream(m.getExceptionTypes()).filter(e -> !e.getName().equals(TException.class.getName())).toArray(Class[]::new)));
        return errorsMap;
    }

    @Override
    public WErrorDefinition mapToDef(Throwable t, ContextSpan contextSpan) {
        InstanceMethodCaller caller = this.getCaller(contextSpan.getMetadata());
        if (caller == null) {
            return null;
        }
        if (this.isDeclaredError(t.getClass(), caller.getTargetMethod())) {
            WErrorDefinition errorDefinition = ContextUtils.getErrorDefinition(contextSpan);
            String errName = this.getDeclaredErrName(t);
            if (errorDefinition == null || errorDefinition.getErrorType() != WErrorType.BUSINESS_ERROR || !Objects.equals(errorDefinition.getErrorName(), errName)) {
                errorDefinition = new WErrorDefinition(WErrorSource.INTERNAL);
                errorDefinition.setErrorType(WErrorType.BUSINESS_ERROR);
                errorDefinition.setErrorSource(WErrorSource.INTERNAL);
                errorDefinition.setErrorReason((String)BUSINESS_ERROR_REASON_FUNC.apply(errName));
                errorDefinition.setErrorName(errName);
                errorDefinition.setErrorMessage(t.getMessage());
            }
            return errorDefinition;
        }
        return null;
    }

    @Override
    public Exception mapToError(WErrorDefinition errorDefinition, ContextSpan contextSpan) {
        return null;
    }

    private boolean isDeclaredError(Class errClass, Method callMethod) {
        Class[] declaredErrors = this.errorsMap.get(callMethod);
        if (declaredErrors != null) {
            for (int i = 0; i < declaredErrors.length; ++i) {
                if (!declaredErrors[i].isAssignableFrom(errClass)) continue;
                return true;
            }
        }
        return false;
    }

    private InstanceMethodCaller getCaller(Metadata metadata) {
        Object callerObj = metadata.getValue("md_instance_method_caller");
        return callerObj instanceof InstanceMethodCaller ? (InstanceMethodCaller)callerObj : null;
    }

    private String getDeclaredErrName(Throwable t) {
        try {
            Field field = t.getClass().getDeclaredField("STRUCT_DESC");
            field.setAccessible(true);
            Object struct = field.get(t);
            if (struct instanceof TStruct) {
                return ((TStruct)struct).name;
            }
            return null;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }
}

