/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.trace;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Metadata {
    private static final int DEFAULT_INIT_SIZE = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final boolean overrideKeys;
    private Map<String, Object> values;

    public Metadata() {
        this(true);
    }

    public Metadata(boolean overrideKeys) {
        this.overrideKeys = overrideKeys;
        this.values = Metadata.createStore(16, 0.75f);
    }

    protected Metadata(Metadata oldMetadata) {
        this.overrideKeys = oldMetadata.overrideKeys;
        this.values = Metadata.cloneStore(oldMetadata.values);
    }

    public <T> T getValue(String key) {
        return (T)this.values.get(key);
    }

    public <T> T removeValue(String key) {
        if (this.overrideKeys) {
            return (T)this.values.remove(key);
        }
        if (this.values.containsKey(key)) {
            throw new IllegalStateException("Value overriding is not allowed");
        }
        return null;
    }

    public <T> T putValue(String key, Object value) {
        if (this.overrideKeys) {
            return (T)this.values.put(key, value);
        }
        if (this.values.containsKey(key)) {
            throw new IllegalStateException("Value overriding is not allowed");
        }
        return (T)this.values.put(key, value);
    }

    public boolean isOverrideKeys() {
        return this.overrideKeys;
    }

    public boolean containsKey(String key) {
        return this.values.containsKey(key);
    }

    public Collection<String> getKeys() {
        return this.values.keySet();
    }

    public void reset() {
        this.values = Metadata.createStore(16, 0.75f);
    }

    public Metadata cloneObject() {
        return new Metadata(this);
    }

    private static HashMap<String, Object> createStore(int size, float loadFactor) {
        return new HashMap<String, Object>(size, loadFactor);
    }

    private static Map<String, Object> cloneStore(Map<String, Object> oldMap) {
        HashMap<String, Object> newMap = Metadata.createStore(16, 0.75f);
        newMap.putAll(oldMap);
        return newMap;
    }
}

