/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.woody.api.proxy;

import dev.vality.woody.api.proxy.InvocationTargetProvider;
import java.util.function.Supplier;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.AbandonedConfig;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class CPool2TargetProvider<T>
implements InvocationTargetProvider<T> {
    private final ObjectPool<T> pool;
    private final Class<T> targetType;

    public static <T> CPool2TargetProvider<T> newInstance(Class<T> targetType, Supplier<TargetObjectFactory<T>> objFactoryFunc, GenericObjectPoolConfig config, AbandonedConfig abandonedConfig) {
        if (config == null) {
            return new CPool2TargetProvider<T>(targetType, objFactoryFunc);
        }
        if (abandonedConfig == null) {
            return new CPool2TargetProvider<T>(targetType, objFactoryFunc, config);
        }
        return new CPool2TargetProvider<T>(targetType, objFactoryFunc, config, abandonedConfig);
    }

    public CPool2TargetProvider(Class<T> targetType, Supplier<TargetObjectFactory<T>> objFactoryFunc) {
        this.targetType = targetType;
        this.pool = new GenericObjectPool(objFactoryFunc.get());
    }

    public CPool2TargetProvider(Class<T> targetType, Supplier<TargetObjectFactory<T>> objFactoryFunc, GenericObjectPoolConfig config) {
        this.targetType = targetType;
        this.pool = new GenericObjectPool(objFactoryFunc.get(), config);
    }

    public CPool2TargetProvider(Class<T> targetType, Supplier<TargetObjectFactory<T>> objFactoryFunc, GenericObjectPoolConfig config, AbandonedConfig abandonedConfig) {
        this.targetType = targetType;
        this.pool = new GenericObjectPool(objFactoryFunc.get(), config, abandonedConfig);
    }

    @Override
    public T getTarget() {
        try {
            return this.pool.borrowObject();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IllegalStateException("Failed to borrow object", e);
        }
    }

    @Override
    public Class<T> getTargetType() {
        return this.targetType;
    }

    @Override
    public void releaseTarget(T target) {
        try {
            this.pool.returnObject(target);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IllegalStateException("Failed to release object", e);
        }
    }

    public void close() {
        this.pool.close();
    }

    @Override
    public boolean isSingleTarget() {
        return false;
    }

    public static class TargetObjectFactory<T>
    extends BasePooledObjectFactory<T> {
        private final Supplier<T> targetSupplier;

        public TargetObjectFactory(Supplier<T> targetSupplier) {
            this.targetSupplier = targetSupplier;
        }

        @Override
        public T create() {
            return this.targetSupplier.get();
        }

        @Override
        public PooledObject<T> wrap(T target) {
            return new DefaultPooledObject<T>(target);
        }
    }
}

