/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.fistful.base;

import dev.vality.fistful.base.BankCardExpDate;
import dev.vality.fistful.base.CardType;
import dev.vality.fistful.base.LegacyBankCardPaymentSystem;
import dev.vality.fistful.base.PaymentSystemRef;
import dev.vality.fistful.base.Residence;
import dev.vality.fistful.msgpack.Value;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class BankCard
implements TBase<BankCard, _Fields>,
Serializable,
Cloneable,
Comparable<BankCard> {
    private static final TStruct STRUCT_DESC = new TStruct("BankCard");
    private static final TField TOKEN_FIELD_DESC = new TField("token", 11, 1);
    private static final TField BIN_FIELD_DESC = new TField("bin", 11, 3);
    private static final TField MASKED_PAN_FIELD_DESC = new TField("masked_pan", 11, 4);
    private static final TField PAYMENT_SYSTEM_DEPRECATED_FIELD_DESC = new TField("payment_system_deprecated", 8, 2);
    private static final TField ISSUER_COUNTRY_FIELD_DESC = new TField("issuer_country", 8, 6);
    private static final TField BANK_NAME_FIELD_DESC = new TField("bank_name", 11, 7);
    private static final TField EXP_DATE_FIELD_DESC = new TField("exp_date", 12, 10);
    private static final TField CARDHOLDER_NAME_FIELD_DESC = new TField("cardholder_name", 11, 11);
    private static final TField CATEGORY_FIELD_DESC = new TField("category", 11, 12);
    private static final TField CARD_TYPE_FIELD_DESC = new TField("card_type", 8, 20);
    private static final TField BIN_DATA_ID_FIELD_DESC = new TField("bin_data_id", 12, 21);
    private static final TField PAYMENT_SYSTEM_FIELD_DESC = new TField("payment_system", 12, 23);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new BankCardStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new BankCardTupleSchemeFactory();
    @Nullable
    public String token;
    @Nullable
    public String bin;
    @Nullable
    public String masked_pan;
    @Nullable
    public LegacyBankCardPaymentSystem payment_system_deprecated;
    @Nullable
    public Residence issuer_country;
    @Nullable
    public String bank_name;
    @Nullable
    public BankCardExpDate exp_date;
    @Nullable
    public String cardholder_name;
    @Nullable
    public String category;
    @Nullable
    public CardType card_type;
    @Nullable
    public Value bin_data_id;
    @Nullable
    public PaymentSystemRef payment_system;
    private static final _Fields[] optionals = new _Fields[]{_Fields.BIN, _Fields.MASKED_PAN, _Fields.PAYMENT_SYSTEM_DEPRECATED, _Fields.ISSUER_COUNTRY, _Fields.BANK_NAME, _Fields.EXP_DATE, _Fields.CARDHOLDER_NAME, _Fields.CATEGORY, _Fields.CARD_TYPE, _Fields.BIN_DATA_ID, _Fields.PAYMENT_SYSTEM};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public BankCard() {
    }

    public BankCard(String token) {
        this();
        this.token = token;
    }

    public BankCard(BankCard other) {
        if (other.isSetToken()) {
            this.token = other.token;
        }
        if (other.isSetBin()) {
            this.bin = other.bin;
        }
        if (other.isSetMaskedPan()) {
            this.masked_pan = other.masked_pan;
        }
        if (other.isSetPaymentSystemDeprecated()) {
            this.payment_system_deprecated = other.payment_system_deprecated;
        }
        if (other.isSetIssuerCountry()) {
            this.issuer_country = other.issuer_country;
        }
        if (other.isSetBankName()) {
            this.bank_name = other.bank_name;
        }
        if (other.isSetExpDate()) {
            this.exp_date = new BankCardExpDate(other.exp_date);
        }
        if (other.isSetCardholderName()) {
            this.cardholder_name = other.cardholder_name;
        }
        if (other.isSetCategory()) {
            this.category = other.category;
        }
        if (other.isSetCardType()) {
            this.card_type = other.card_type;
        }
        if (other.isSetBinDataId()) {
            this.bin_data_id = new Value(other.bin_data_id);
        }
        if (other.isSetPaymentSystem()) {
            this.payment_system = new PaymentSystemRef(other.payment_system);
        }
    }

    public BankCard deepCopy() {
        return new BankCard(this);
    }

    public void clear() {
        this.token = null;
        this.bin = null;
        this.masked_pan = null;
        this.payment_system_deprecated = null;
        this.issuer_country = null;
        this.bank_name = null;
        this.exp_date = null;
        this.cardholder_name = null;
        this.category = null;
        this.card_type = null;
        this.bin_data_id = null;
        this.payment_system = null;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    public BankCard setToken(@Nullable String token) {
        this.token = token;
        return this;
    }

    public void unsetToken() {
        this.token = null;
    }

    public boolean isSetToken() {
        return this.token != null;
    }

    public void setTokenIsSet(boolean value) {
        if (!value) {
            this.token = null;
        }
    }

    @Nullable
    public String getBin() {
        return this.bin;
    }

    public BankCard setBin(@Nullable String bin) {
        this.bin = bin;
        return this;
    }

    public void unsetBin() {
        this.bin = null;
    }

    public boolean isSetBin() {
        return this.bin != null;
    }

    public void setBinIsSet(boolean value) {
        if (!value) {
            this.bin = null;
        }
    }

    @Nullable
    public String getMaskedPan() {
        return this.masked_pan;
    }

    public BankCard setMaskedPan(@Nullable String masked_pan) {
        this.masked_pan = masked_pan;
        return this;
    }

    public void unsetMaskedPan() {
        this.masked_pan = null;
    }

    public boolean isSetMaskedPan() {
        return this.masked_pan != null;
    }

    public void setMaskedPanIsSet(boolean value) {
        if (!value) {
            this.masked_pan = null;
        }
    }

    @Nullable
    public LegacyBankCardPaymentSystem getPaymentSystemDeprecated() {
        return this.payment_system_deprecated;
    }

    public BankCard setPaymentSystemDeprecated(@Nullable LegacyBankCardPaymentSystem payment_system_deprecated) {
        this.payment_system_deprecated = payment_system_deprecated;
        return this;
    }

    public void unsetPaymentSystemDeprecated() {
        this.payment_system_deprecated = null;
    }

    public boolean isSetPaymentSystemDeprecated() {
        return this.payment_system_deprecated != null;
    }

    public void setPaymentSystemDeprecatedIsSet(boolean value) {
        if (!value) {
            this.payment_system_deprecated = null;
        }
    }

    @Nullable
    public Residence getIssuerCountry() {
        return this.issuer_country;
    }

    public BankCard setIssuerCountry(@Nullable Residence issuer_country) {
        this.issuer_country = issuer_country;
        return this;
    }

    public void unsetIssuerCountry() {
        this.issuer_country = null;
    }

    public boolean isSetIssuerCountry() {
        return this.issuer_country != null;
    }

    public void setIssuerCountryIsSet(boolean value) {
        if (!value) {
            this.issuer_country = null;
        }
    }

    @Nullable
    public String getBankName() {
        return this.bank_name;
    }

    public BankCard setBankName(@Nullable String bank_name) {
        this.bank_name = bank_name;
        return this;
    }

    public void unsetBankName() {
        this.bank_name = null;
    }

    public boolean isSetBankName() {
        return this.bank_name != null;
    }

    public void setBankNameIsSet(boolean value) {
        if (!value) {
            this.bank_name = null;
        }
    }

    @Nullable
    public BankCardExpDate getExpDate() {
        return this.exp_date;
    }

    public BankCard setExpDate(@Nullable BankCardExpDate exp_date) {
        this.exp_date = exp_date;
        return this;
    }

    public void unsetExpDate() {
        this.exp_date = null;
    }

    public boolean isSetExpDate() {
        return this.exp_date != null;
    }

    public void setExpDateIsSet(boolean value) {
        if (!value) {
            this.exp_date = null;
        }
    }

    @Nullable
    public String getCardholderName() {
        return this.cardholder_name;
    }

    public BankCard setCardholderName(@Nullable String cardholder_name) {
        this.cardholder_name = cardholder_name;
        return this;
    }

    public void unsetCardholderName() {
        this.cardholder_name = null;
    }

    public boolean isSetCardholderName() {
        return this.cardholder_name != null;
    }

    public void setCardholderNameIsSet(boolean value) {
        if (!value) {
            this.cardholder_name = null;
        }
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    public BankCard setCategory(@Nullable String category) {
        this.category = category;
        return this;
    }

    public void unsetCategory() {
        this.category = null;
    }

    public boolean isSetCategory() {
        return this.category != null;
    }

    public void setCategoryIsSet(boolean value) {
        if (!value) {
            this.category = null;
        }
    }

    @Nullable
    public CardType getCardType() {
        return this.card_type;
    }

    public BankCard setCardType(@Nullable CardType card_type) {
        this.card_type = card_type;
        return this;
    }

    public void unsetCardType() {
        this.card_type = null;
    }

    public boolean isSetCardType() {
        return this.card_type != null;
    }

    public void setCardTypeIsSet(boolean value) {
        if (!value) {
            this.card_type = null;
        }
    }

    @Nullable
    public Value getBinDataId() {
        return this.bin_data_id;
    }

    public BankCard setBinDataId(@Nullable Value bin_data_id) {
        this.bin_data_id = bin_data_id;
        return this;
    }

    public void unsetBinDataId() {
        this.bin_data_id = null;
    }

    public boolean isSetBinDataId() {
        return this.bin_data_id != null;
    }

    public void setBinDataIdIsSet(boolean value) {
        if (!value) {
            this.bin_data_id = null;
        }
    }

    @Nullable
    public PaymentSystemRef getPaymentSystem() {
        return this.payment_system;
    }

    public BankCard setPaymentSystem(@Nullable PaymentSystemRef payment_system) {
        this.payment_system = payment_system;
        return this;
    }

    public void unsetPaymentSystem() {
        this.payment_system = null;
    }

    public boolean isSetPaymentSystem() {
        return this.payment_system != null;
    }

    public void setPaymentSystemIsSet(boolean value) {
        if (!value) {
            this.payment_system = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TOKEN: {
                if (value == null) {
                    this.unsetToken();
                    break;
                }
                this.setToken((String)value);
                break;
            }
            case BIN: {
                if (value == null) {
                    this.unsetBin();
                    break;
                }
                this.setBin((String)value);
                break;
            }
            case MASKED_PAN: {
                if (value == null) {
                    this.unsetMaskedPan();
                    break;
                }
                this.setMaskedPan((String)value);
                break;
            }
            case PAYMENT_SYSTEM_DEPRECATED: {
                if (value == null) {
                    this.unsetPaymentSystemDeprecated();
                    break;
                }
                this.setPaymentSystemDeprecated((LegacyBankCardPaymentSystem)((Object)value));
                break;
            }
            case ISSUER_COUNTRY: {
                if (value == null) {
                    this.unsetIssuerCountry();
                    break;
                }
                this.setIssuerCountry((Residence)((Object)value));
                break;
            }
            case BANK_NAME: {
                if (value == null) {
                    this.unsetBankName();
                    break;
                }
                this.setBankName((String)value);
                break;
            }
            case EXP_DATE: {
                if (value == null) {
                    this.unsetExpDate();
                    break;
                }
                this.setExpDate((BankCardExpDate)value);
                break;
            }
            case CARDHOLDER_NAME: {
                if (value == null) {
                    this.unsetCardholderName();
                    break;
                }
                this.setCardholderName((String)value);
                break;
            }
            case CATEGORY: {
                if (value == null) {
                    this.unsetCategory();
                    break;
                }
                this.setCategory((String)value);
                break;
            }
            case CARD_TYPE: {
                if (value == null) {
                    this.unsetCardType();
                    break;
                }
                this.setCardType((CardType)((Object)value));
                break;
            }
            case BIN_DATA_ID: {
                if (value == null) {
                    this.unsetBinDataId();
                    break;
                }
                this.setBinDataId((Value)((Object)value));
                break;
            }
            case PAYMENT_SYSTEM: {
                if (value == null) {
                    this.unsetPaymentSystem();
                    break;
                }
                this.setPaymentSystem((PaymentSystemRef)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TOKEN: {
                return this.getToken();
            }
            case BIN: {
                return this.getBin();
            }
            case MASKED_PAN: {
                return this.getMaskedPan();
            }
            case PAYMENT_SYSTEM_DEPRECATED: {
                return this.getPaymentSystemDeprecated();
            }
            case ISSUER_COUNTRY: {
                return this.getIssuerCountry();
            }
            case BANK_NAME: {
                return this.getBankName();
            }
            case EXP_DATE: {
                return this.getExpDate();
            }
            case CARDHOLDER_NAME: {
                return this.getCardholderName();
            }
            case CATEGORY: {
                return this.getCategory();
            }
            case CARD_TYPE: {
                return this.getCardType();
            }
            case BIN_DATA_ID: {
                return this.getBinDataId();
            }
            case PAYMENT_SYSTEM: {
                return this.getPaymentSystem();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TOKEN: {
                return this.isSetToken();
            }
            case BIN: {
                return this.isSetBin();
            }
            case MASKED_PAN: {
                return this.isSetMaskedPan();
            }
            case PAYMENT_SYSTEM_DEPRECATED: {
                return this.isSetPaymentSystemDeprecated();
            }
            case ISSUER_COUNTRY: {
                return this.isSetIssuerCountry();
            }
            case BANK_NAME: {
                return this.isSetBankName();
            }
            case EXP_DATE: {
                return this.isSetExpDate();
            }
            case CARDHOLDER_NAME: {
                return this.isSetCardholderName();
            }
            case CATEGORY: {
                return this.isSetCategory();
            }
            case CARD_TYPE: {
                return this.isSetCardType();
            }
            case BIN_DATA_ID: {
                return this.isSetBinDataId();
            }
            case PAYMENT_SYSTEM: {
                return this.isSetPaymentSystem();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof BankCard) {
            return this.equals((BankCard)that);
        }
        return false;
    }

    public boolean equals(BankCard that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_token = this.isSetToken();
        boolean that_present_token = that.isSetToken();
        if (this_present_token || that_present_token) {
            if (!this_present_token || !that_present_token) {
                return false;
            }
            if (!this.token.equals(that.token)) {
                return false;
            }
        }
        boolean this_present_bin = this.isSetBin();
        boolean that_present_bin = that.isSetBin();
        if (this_present_bin || that_present_bin) {
            if (!this_present_bin || !that_present_bin) {
                return false;
            }
            if (!this.bin.equals(that.bin)) {
                return false;
            }
        }
        boolean this_present_masked_pan = this.isSetMaskedPan();
        boolean that_present_masked_pan = that.isSetMaskedPan();
        if (this_present_masked_pan || that_present_masked_pan) {
            if (!this_present_masked_pan || !that_present_masked_pan) {
                return false;
            }
            if (!this.masked_pan.equals(that.masked_pan)) {
                return false;
            }
        }
        boolean this_present_payment_system_deprecated = this.isSetPaymentSystemDeprecated();
        boolean that_present_payment_system_deprecated = that.isSetPaymentSystemDeprecated();
        if (this_present_payment_system_deprecated || that_present_payment_system_deprecated) {
            if (!this_present_payment_system_deprecated || !that_present_payment_system_deprecated) {
                return false;
            }
            if (!this.payment_system_deprecated.equals((Object)that.payment_system_deprecated)) {
                return false;
            }
        }
        boolean this_present_issuer_country = this.isSetIssuerCountry();
        boolean that_present_issuer_country = that.isSetIssuerCountry();
        if (this_present_issuer_country || that_present_issuer_country) {
            if (!this_present_issuer_country || !that_present_issuer_country) {
                return false;
            }
            if (!this.issuer_country.equals((Object)that.issuer_country)) {
                return false;
            }
        }
        boolean this_present_bank_name = this.isSetBankName();
        boolean that_present_bank_name = that.isSetBankName();
        if (this_present_bank_name || that_present_bank_name) {
            if (!this_present_bank_name || !that_present_bank_name) {
                return false;
            }
            if (!this.bank_name.equals(that.bank_name)) {
                return false;
            }
        }
        boolean this_present_exp_date = this.isSetExpDate();
        boolean that_present_exp_date = that.isSetExpDate();
        if (this_present_exp_date || that_present_exp_date) {
            if (!this_present_exp_date || !that_present_exp_date) {
                return false;
            }
            if (!this.exp_date.equals(that.exp_date)) {
                return false;
            }
        }
        boolean this_present_cardholder_name = this.isSetCardholderName();
        boolean that_present_cardholder_name = that.isSetCardholderName();
        if (this_present_cardholder_name || that_present_cardholder_name) {
            if (!this_present_cardholder_name || !that_present_cardholder_name) {
                return false;
            }
            if (!this.cardholder_name.equals(that.cardholder_name)) {
                return false;
            }
        }
        boolean this_present_category = this.isSetCategory();
        boolean that_present_category = that.isSetCategory();
        if (this_present_category || that_present_category) {
            if (!this_present_category || !that_present_category) {
                return false;
            }
            if (!this.category.equals(that.category)) {
                return false;
            }
        }
        boolean this_present_card_type = this.isSetCardType();
        boolean that_present_card_type = that.isSetCardType();
        if (this_present_card_type || that_present_card_type) {
            if (!this_present_card_type || !that_present_card_type) {
                return false;
            }
            if (!this.card_type.equals((Object)that.card_type)) {
                return false;
            }
        }
        boolean this_present_bin_data_id = this.isSetBinDataId();
        boolean that_present_bin_data_id = that.isSetBinDataId();
        if (this_present_bin_data_id || that_present_bin_data_id) {
            if (!this_present_bin_data_id || !that_present_bin_data_id) {
                return false;
            }
            if (!this.bin_data_id.equals(that.bin_data_id)) {
                return false;
            }
        }
        boolean this_present_payment_system = this.isSetPaymentSystem();
        boolean that_present_payment_system = that.isSetPaymentSystem();
        if (this_present_payment_system || that_present_payment_system) {
            if (!this_present_payment_system || !that_present_payment_system) {
                return false;
            }
            if (!this.payment_system.equals(that.payment_system)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetToken() ? 131071 : 524287);
        if (this.isSetToken()) {
            hashCode = hashCode * 8191 + this.token.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetBin() ? 131071 : 524287);
        if (this.isSetBin()) {
            hashCode = hashCode * 8191 + this.bin.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetMaskedPan() ? 131071 : 524287);
        if (this.isSetMaskedPan()) {
            hashCode = hashCode * 8191 + this.masked_pan.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPaymentSystemDeprecated() ? 131071 : 524287);
        if (this.isSetPaymentSystemDeprecated()) {
            hashCode = hashCode * 8191 + this.payment_system_deprecated.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetIssuerCountry() ? 131071 : 524287);
        if (this.isSetIssuerCountry()) {
            hashCode = hashCode * 8191 + this.issuer_country.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetBankName() ? 131071 : 524287);
        if (this.isSetBankName()) {
            hashCode = hashCode * 8191 + this.bank_name.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetExpDate() ? 131071 : 524287);
        if (this.isSetExpDate()) {
            hashCode = hashCode * 8191 + this.exp_date.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCardholderName() ? 131071 : 524287);
        if (this.isSetCardholderName()) {
            hashCode = hashCode * 8191 + this.cardholder_name.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCategory() ? 131071 : 524287);
        if (this.isSetCategory()) {
            hashCode = hashCode * 8191 + this.category.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCardType() ? 131071 : 524287);
        if (this.isSetCardType()) {
            hashCode = hashCode * 8191 + this.card_type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetBinDataId() ? 131071 : 524287);
        if (this.isSetBinDataId()) {
            hashCode = hashCode * 8191 + this.bin_data_id.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPaymentSystem() ? 131071 : 524287);
        if (this.isSetPaymentSystem()) {
            hashCode = hashCode * 8191 + this.payment_system.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(BankCard other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetToken(), other.isSetToken());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetToken() && (lastComparison = TBaseHelper.compareTo((String)this.token, (String)other.token)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetBin(), other.isSetBin());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBin() && (lastComparison = TBaseHelper.compareTo((String)this.bin, (String)other.bin)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMaskedPan(), other.isSetMaskedPan());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaskedPan() && (lastComparison = TBaseHelper.compareTo((String)this.masked_pan, (String)other.masked_pan)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPaymentSystemDeprecated(), other.isSetPaymentSystemDeprecated());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPaymentSystemDeprecated() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.payment_system_deprecated), (Comparable)((Object)other.payment_system_deprecated))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIssuerCountry(), other.isSetIssuerCountry());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIssuerCountry() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.issuer_country), (Comparable)((Object)other.issuer_country))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetBankName(), other.isSetBankName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBankName() && (lastComparison = TBaseHelper.compareTo((String)this.bank_name, (String)other.bank_name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetExpDate(), other.isSetExpDate());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExpDate() && (lastComparison = TBaseHelper.compareTo((Comparable)this.exp_date, (Comparable)other.exp_date)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCardholderName(), other.isSetCardholderName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCardholderName() && (lastComparison = TBaseHelper.compareTo((String)this.cardholder_name, (String)other.cardholder_name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCategory(), other.isSetCategory());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCategory() && (lastComparison = TBaseHelper.compareTo((String)this.category, (String)other.category)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCardType(), other.isSetCardType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCardType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.card_type), (Comparable)((Object)other.card_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetBinDataId(), other.isSetBinDataId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBinDataId() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.bin_data_id), (Comparable)((Object)other.bin_data_id))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPaymentSystem(), other.isSetPaymentSystem());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPaymentSystem() && (lastComparison = TBaseHelper.compareTo((Comparable)this.payment_system, (Comparable)other.payment_system)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public _Fields[] getFields() {
        return _Fields.values();
    }

    public Map<_Fields, FieldMetaData> getFieldMetaData() {
        return metaDataMap;
    }

    public void read(TProtocol iprot) throws TException {
        BankCard.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        BankCard.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BankCard(");
        boolean first = true;
        sb.append("token:");
        if (this.token == null) {
            sb.append("null");
        } else {
            sb.append(this.token);
        }
        first = false;
        if (this.isSetBin()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("bin:");
            if (this.bin == null) {
                sb.append("null");
            } else {
                sb.append(this.bin);
            }
            first = false;
        }
        if (this.isSetMaskedPan()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("masked_pan:");
            if (this.masked_pan == null) {
                sb.append("null");
            } else {
                sb.append(this.masked_pan);
            }
            first = false;
        }
        if (this.isSetPaymentSystemDeprecated()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("payment_system_deprecated:");
            if (this.payment_system_deprecated == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.payment_system_deprecated);
            }
            first = false;
        }
        if (this.isSetIssuerCountry()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("issuer_country:");
            if (this.issuer_country == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.issuer_country);
            }
            first = false;
        }
        if (this.isSetBankName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("bank_name:");
            if (this.bank_name == null) {
                sb.append("null");
            } else {
                sb.append(this.bank_name);
            }
            first = false;
        }
        if (this.isSetExpDate()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("exp_date:");
            if (this.exp_date == null) {
                sb.append("null");
            } else {
                sb.append(this.exp_date);
            }
            first = false;
        }
        if (this.isSetCardholderName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("cardholder_name:");
            if (this.cardholder_name == null) {
                sb.append("null");
            } else {
                sb.append(this.cardholder_name);
            }
            first = false;
        }
        if (this.isSetCategory()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("category:");
            if (this.category == null) {
                sb.append("null");
            } else {
                sb.append(this.category);
            }
            first = false;
        }
        if (this.isSetCardType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("card_type:");
            if (this.card_type == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.card_type);
            }
            first = false;
        }
        if (this.isSetBinDataId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("bin_data_id:");
            if (this.bin_data_id == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.bin_data_id);
            }
            first = false;
        }
        if (this.isSetPaymentSystem()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("payment_system:");
            if (this.payment_system == null) {
                sb.append("null");
            } else {
                sb.append(this.payment_system);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.token == null) {
            throw new TProtocolException("Required field 'token' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TOKEN, new FieldMetaData("token", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.BIN, new FieldMetaData("bin", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.MASKED_PAN, new FieldMetaData("masked_pan", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PAYMENT_SYSTEM_DEPRECATED, new FieldMetaData("payment_system_deprecated", 2, (FieldValueMetaData)new EnumMetaData(16, LegacyBankCardPaymentSystem.class)));
        tmpMap.put(_Fields.ISSUER_COUNTRY, new FieldMetaData("issuer_country", 2, (FieldValueMetaData)new EnumMetaData(16, Residence.class)));
        tmpMap.put(_Fields.BANK_NAME, new FieldMetaData("bank_name", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.EXP_DATE, new FieldMetaData("exp_date", 2, (FieldValueMetaData)new StructMetaData(12, BankCardExpDate.class)));
        tmpMap.put(_Fields.CARDHOLDER_NAME, new FieldMetaData("cardholder_name", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CATEGORY, new FieldMetaData("category", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CARD_TYPE, new FieldMetaData("card_type", 2, (FieldValueMetaData)new EnumMetaData(16, CardType.class)));
        tmpMap.put(_Fields.BIN_DATA_ID, new FieldMetaData("bin_data_id", 2, (FieldValueMetaData)new StructMetaData(12, Value.class)));
        tmpMap.put(_Fields.PAYMENT_SYSTEM, new FieldMetaData("payment_system", 2, (FieldValueMetaData)new StructMetaData(12, PaymentSystemRef.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(BankCard.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TOKEN(1, "token"),
        BIN(3, "bin"),
        MASKED_PAN(4, "masked_pan"),
        PAYMENT_SYSTEM_DEPRECATED(2, "payment_system_deprecated"),
        ISSUER_COUNTRY(6, "issuer_country"),
        BANK_NAME(7, "bank_name"),
        EXP_DATE(10, "exp_date"),
        CARDHOLDER_NAME(11, "cardholder_name"),
        CATEGORY(12, "category"),
        CARD_TYPE(20, "card_type"),
        BIN_DATA_ID(21, "bin_data_id"),
        PAYMENT_SYSTEM(23, "payment_system");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TOKEN;
                }
                case 3: {
                    return BIN;
                }
                case 4: {
                    return MASKED_PAN;
                }
                case 2: {
                    return PAYMENT_SYSTEM_DEPRECATED;
                }
                case 6: {
                    return ISSUER_COUNTRY;
                }
                case 7: {
                    return BANK_NAME;
                }
                case 10: {
                    return EXP_DATE;
                }
                case 11: {
                    return CARDHOLDER_NAME;
                }
                case 12: {
                    return CATEGORY;
                }
                case 20: {
                    return CARD_TYPE;
                }
                case 21: {
                    return BIN_DATA_ID;
                }
                case 23: {
                    return PAYMENT_SYSTEM;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class BankCardStandardSchemeFactory
    implements SchemeFactory {
        private BankCardStandardSchemeFactory() {
        }

        public BankCardStandardScheme getScheme() {
            return new BankCardStandardScheme();
        }
    }

    private static class BankCardTupleSchemeFactory
    implements SchemeFactory {
        private BankCardTupleSchemeFactory() {
        }

        public BankCardTupleScheme getScheme() {
            return new BankCardTupleScheme();
        }
    }

    private static class BankCardTupleScheme
    extends TupleScheme<BankCard> {
        private BankCardTupleScheme() {
        }

        public void write(TProtocol prot, BankCard struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.token);
            BitSet optionals = new BitSet();
            if (struct.isSetBin()) {
                optionals.set(0);
            }
            if (struct.isSetMaskedPan()) {
                optionals.set(1);
            }
            if (struct.isSetPaymentSystemDeprecated()) {
                optionals.set(2);
            }
            if (struct.isSetIssuerCountry()) {
                optionals.set(3);
            }
            if (struct.isSetBankName()) {
                optionals.set(4);
            }
            if (struct.isSetExpDate()) {
                optionals.set(5);
            }
            if (struct.isSetCardholderName()) {
                optionals.set(6);
            }
            if (struct.isSetCategory()) {
                optionals.set(7);
            }
            if (struct.isSetCardType()) {
                optionals.set(8);
            }
            if (struct.isSetBinDataId()) {
                optionals.set(9);
            }
            if (struct.isSetPaymentSystem()) {
                optionals.set(10);
            }
            oprot.writeBitSet(optionals, 11);
            if (struct.isSetBin()) {
                oprot.writeString(struct.bin);
            }
            if (struct.isSetMaskedPan()) {
                oprot.writeString(struct.masked_pan);
            }
            if (struct.isSetPaymentSystemDeprecated()) {
                oprot.writeI32(struct.payment_system_deprecated.getValue());
            }
            if (struct.isSetIssuerCountry()) {
                oprot.writeI32(struct.issuer_country.getValue());
            }
            if (struct.isSetBankName()) {
                oprot.writeString(struct.bank_name);
            }
            if (struct.isSetExpDate()) {
                struct.exp_date.write((TProtocol)oprot);
            }
            if (struct.isSetCardholderName()) {
                oprot.writeString(struct.cardholder_name);
            }
            if (struct.isSetCategory()) {
                oprot.writeString(struct.category);
            }
            if (struct.isSetCardType()) {
                oprot.writeI32(struct.card_type.getValue());
            }
            if (struct.isSetBinDataId()) {
                struct.bin_data_id.write((TProtocol)oprot);
            }
            if (struct.isSetPaymentSystem()) {
                struct.payment_system.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, BankCard struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.token = iprot.readString();
            struct.setTokenIsSet(true);
            BitSet incoming = iprot.readBitSet(11);
            if (incoming.get(0)) {
                struct.bin = iprot.readString();
                struct.setBinIsSet(true);
            }
            if (incoming.get(1)) {
                struct.masked_pan = iprot.readString();
                struct.setMaskedPanIsSet(true);
            }
            if (incoming.get(2)) {
                struct.payment_system_deprecated = LegacyBankCardPaymentSystem.findByValue(iprot.readI32());
                struct.setPaymentSystemDeprecatedIsSet(true);
            }
            if (incoming.get(3)) {
                struct.issuer_country = Residence.findByValue(iprot.readI32());
                struct.setIssuerCountryIsSet(true);
            }
            if (incoming.get(4)) {
                struct.bank_name = iprot.readString();
                struct.setBankNameIsSet(true);
            }
            if (incoming.get(5)) {
                struct.exp_date = new BankCardExpDate();
                struct.exp_date.read((TProtocol)iprot);
                struct.setExpDateIsSet(true);
            }
            if (incoming.get(6)) {
                struct.cardholder_name = iprot.readString();
                struct.setCardholderNameIsSet(true);
            }
            if (incoming.get(7)) {
                struct.category = iprot.readString();
                struct.setCategoryIsSet(true);
            }
            if (incoming.get(8)) {
                struct.card_type = CardType.findByValue(iprot.readI32());
                struct.setCardTypeIsSet(true);
            }
            if (incoming.get(9)) {
                struct.bin_data_id = new Value();
                struct.bin_data_id.read((TProtocol)iprot);
                struct.setBinDataIdIsSet(true);
            }
            if (incoming.get(10)) {
                struct.payment_system = new PaymentSystemRef();
                struct.payment_system.read((TProtocol)iprot);
                struct.setPaymentSystemIsSet(true);
            }
        }
    }

    private static class BankCardStandardScheme
    extends StandardScheme<BankCard> {
        private BankCardStandardScheme() {
        }

        public void read(TProtocol iprot, BankCard struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.token = iprot.readString();
                            struct.setTokenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.bin = iprot.readString();
                            struct.setBinIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.masked_pan = iprot.readString();
                            struct.setMaskedPanIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.payment_system_deprecated = LegacyBankCardPaymentSystem.findByValue(iprot.readI32());
                            struct.setPaymentSystemDeprecatedIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.issuer_country = Residence.findByValue(iprot.readI32());
                            struct.setIssuerCountryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.bank_name = iprot.readString();
                            struct.setBankNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 12) {
                            struct.exp_date = new BankCardExpDate();
                            struct.exp_date.read(iprot);
                            struct.setExpDateIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 11) {
                            struct.cardholder_name = iprot.readString();
                            struct.setCardholderNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 11) {
                            struct.category = iprot.readString();
                            struct.setCategoryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 20: {
                        if (schemeField.type == 8) {
                            struct.card_type = CardType.findByValue(iprot.readI32());
                            struct.setCardTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 21: {
                        if (schemeField.type == 12) {
                            struct.bin_data_id = new Value();
                            struct.bin_data_id.read(iprot);
                            struct.setBinDataIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 23: {
                        if (schemeField.type == 12) {
                            struct.payment_system = new PaymentSystemRef();
                            struct.payment_system.read(iprot);
                            struct.setPaymentSystemIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, BankCard struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.token != null) {
                oprot.writeFieldBegin(TOKEN_FIELD_DESC);
                oprot.writeString(struct.token);
                oprot.writeFieldEnd();
            }
            if (struct.payment_system_deprecated != null && struct.isSetPaymentSystemDeprecated()) {
                oprot.writeFieldBegin(PAYMENT_SYSTEM_DEPRECATED_FIELD_DESC);
                oprot.writeI32(struct.payment_system_deprecated.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.bin != null && struct.isSetBin()) {
                oprot.writeFieldBegin(BIN_FIELD_DESC);
                oprot.writeString(struct.bin);
                oprot.writeFieldEnd();
            }
            if (struct.masked_pan != null && struct.isSetMaskedPan()) {
                oprot.writeFieldBegin(MASKED_PAN_FIELD_DESC);
                oprot.writeString(struct.masked_pan);
                oprot.writeFieldEnd();
            }
            if (struct.issuer_country != null && struct.isSetIssuerCountry()) {
                oprot.writeFieldBegin(ISSUER_COUNTRY_FIELD_DESC);
                oprot.writeI32(struct.issuer_country.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.bank_name != null && struct.isSetBankName()) {
                oprot.writeFieldBegin(BANK_NAME_FIELD_DESC);
                oprot.writeString(struct.bank_name);
                oprot.writeFieldEnd();
            }
            if (struct.exp_date != null && struct.isSetExpDate()) {
                oprot.writeFieldBegin(EXP_DATE_FIELD_DESC);
                struct.exp_date.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.cardholder_name != null && struct.isSetCardholderName()) {
                oprot.writeFieldBegin(CARDHOLDER_NAME_FIELD_DESC);
                oprot.writeString(struct.cardholder_name);
                oprot.writeFieldEnd();
            }
            if (struct.category != null && struct.isSetCategory()) {
                oprot.writeFieldBegin(CATEGORY_FIELD_DESC);
                oprot.writeString(struct.category);
                oprot.writeFieldEnd();
            }
            if (struct.card_type != null && struct.isSetCardType()) {
                oprot.writeFieldBegin(CARD_TYPE_FIELD_DESC);
                oprot.writeI32(struct.card_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.bin_data_id != null && struct.isSetBinDataId()) {
                oprot.writeFieldBegin(BIN_DATA_ID_FIELD_DESC);
                struct.bin_data_id.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.payment_system != null && struct.isSetPaymentSystem()) {
                oprot.writeFieldBegin(PAYMENT_SYSTEM_FIELD_DESC);
                struct.payment_system.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

