/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.service.impl;

import dev.vality.adapter.flow.lib.constant.RedirectFields;
import dev.vality.adapter.flow.lib.service.CallbackUrlExtractor;
import dev.vality.adapter.flow.lib.utils.AdapterProperties;
import java.util.Map;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class CallbackUrlExtractorImpl
implements CallbackUrlExtractor {
    private final AdapterProperties adapterProperties;

    @Override
    public String extractCallbackUrl(String redirectUrl) {
        return this.extractCallbackUrl(null, redirectUrl);
    }

    @Override
    public String extractCallbackUrl(Map<String, String> adapterConfigurations, String redirectUrl) {
        return UriComponentsBuilder.fromUriString((String)this.adapterProperties.getCallbackUrl()).path(this.adapterProperties.getPathCallbackUrl()).queryParam("termination_uri", new Object[]{redirectUrl}).build().toUriString();
    }

    @Override
    public String getSuccessRedirectUrl(Map<String, String> adapterConfigurations, String redirectUrl) {
        if (StringUtils.hasText((String)redirectUrl)) {
            return redirectUrl;
        }
        return adapterConfigurations.getOrDefault(RedirectFields.TERM_URL.getValue(), this.adapterProperties.getSuccessRedirectUrl());
    }

    public CallbackUrlExtractorImpl(AdapterProperties adapterProperties) {
        this.adapterProperties = adapterProperties;
    }
}

