/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.service.factory;

import dev.vality.adapter.common.damsel.OptionsExtractors;
import dev.vality.adapter.common.damsel.ProxyProviderPackageCreators;
import dev.vality.adapter.common.mapper.ErrorMapping;
import dev.vality.adapter.flow.lib.constant.HttpMethod;
import dev.vality.adapter.flow.lib.constant.RedirectFields;
import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.ExitStateModel;
import dev.vality.adapter.flow.lib.model.PollingInfo;
import dev.vality.adapter.flow.lib.model.ThreeDsData;
import dev.vality.adapter.flow.lib.serde.ParametersSerializer;
import dev.vality.adapter.flow.lib.service.CallbackUrlExtractor;
import dev.vality.adapter.flow.lib.service.ExponentialBackOffPollingService;
import dev.vality.adapter.flow.lib.service.PollingInfoService;
import dev.vality.adapter.flow.lib.service.TagManagementService;
import dev.vality.adapter.flow.lib.service.factory.IntentResultFactory;
import dev.vality.adapter.flow.lib.utils.ThreeDsDataInitializer;
import dev.vality.adapter.flow.lib.utils.TimeoutUtils;
import dev.vality.adapter.flow.lib.utils.TimerProperties;
import dev.vality.damsel.base.Timer;
import dev.vality.damsel.domain.Failure;
import dev.vality.damsel.proxy_provider.FinishIntent;
import dev.vality.damsel.proxy_provider.FinishStatus;
import dev.vality.damsel.proxy_provider.Intent;
import dev.vality.damsel.proxy_provider.SleepIntent;
import dev.vality.damsel.proxy_provider.Success;
import dev.vality.damsel.proxy_provider.SuspendIntent;
import dev.vality.damsel.timeout_behaviour.TimeoutBehaviour;
import dev.vality.damsel.user_interaction.UserInteraction;
import java.nio.ByteBuffer;
import java.util.Map;

public class SimpleIntentResultFactory
implements IntentResultFactory {
    private final TimerProperties timerProperties;
    private final CallbackUrlExtractor callbackUrlExtractor;
    private final TagManagementService tagManagementService;
    private final ParametersSerializer parametersSerializer;
    private final PollingInfoService pollingInfoService;
    private final ErrorMapping errorMapping;
    private final ExponentialBackOffPollingService exponentialBackOffPollingService;

    @Override
    public Intent createFinishIntentSuccessWithCheckToken(ExitStateModel exitStateModel) {
        EntryStateModel entryStateModel = exitStateModel.getEntryStateModel();
        if (entryStateModel.getBaseRequestModel().getRecurrentPaymentData() != null && entryStateModel.getBaseRequestModel().getRecurrentPaymentData().isMakeRecurrent()) {
            return ProxyProviderPackageCreators.createFinishIntentSuccessWithToken((String)exitStateModel.getRecToken());
        }
        return this.createFinishIntentSuccess();
    }

    @Override
    public Intent createSuspendIntentWithFailedAfterTimeout(ExitStateModel exitStateModel) {
        EntryStateModel entryStateModel = exitStateModel.getEntryStateModel();
        ThreeDsData threeDsData = exitStateModel.getThreeDsData();
        Map<String, String> params = ThreeDsDataInitializer.initThreeDsParameters(exitStateModel);
        String redirectUrl = entryStateModel.getBaseRequestModel().getSuccessRedirectUrl();
        Map<String, String> adapterConfigurations = entryStateModel.getBaseRequestModel().getAdapterConfigurations();
        params.put(RedirectFields.TERM_URL.getValue(), this.callbackUrlExtractor.extractCallbackUrl(adapterConfigurations, redirectUrl));
        int timerRedirectTimeoutMin = OptionsExtractors.extractRedirectTimeout(adapterConfigurations, (int)this.timerProperties.getRedirectTimeoutMin());
        return Intent.suspend((SuspendIntent)new SuspendIntent(this.tagManagementService.findTag(params), Timer.timeout((int)TimeoutUtils.toSeconds(timerRedirectTimeoutMin))).setUserInteraction(this.createUserInteraction(threeDsData, params)));
    }

    @Override
    public Intent createSuspendIntentWithCallbackAfterTimeout(ExitStateModel exitStateModel) {
        Map<String, String> params = ThreeDsDataInitializer.initThreeDsParameters(exitStateModel);
        EntryStateModel entryStateModel = exitStateModel.getEntryStateModel();
        PollingInfo pollingInfo = this.pollingInfoService.initPollingInfo(entryStateModel);
        if (this.pollingInfoService.isDeadline(pollingInfo)) {
            return this.createFinishIntentFailed("Sleep timeout", "Max time pool limit reached");
        }
        exitStateModel.setPollingInfo(pollingInfo);
        String redirectUrl = entryStateModel.getBaseRequestModel().getSuccessRedirectUrl();
        Map<String, String> adapterConfigurations = entryStateModel.getBaseRequestModel().getAdapterConfigurations();
        params.put(RedirectFields.TERM_URL.getValue(), this.callbackUrlExtractor.extractCallbackUrl(adapterConfigurations, redirectUrl));
        ThreeDsData threeDsData = exitStateModel.getThreeDsData();
        int timerRedirectTimeoutMin = OptionsExtractors.extractRedirectTimeout(adapterConfigurations, (int)this.timerProperties.getRedirectTimeoutMin());
        return Intent.suspend((SuspendIntent)new SuspendIntent(this.tagManagementService.findTag(params), Timer.timeout((int)TimeoutUtils.toSeconds(timerRedirectTimeoutMin))).setTimeoutBehaviour(TimeoutBehaviour.callback((ByteBuffer)ByteBuffer.wrap(this.parametersSerializer.writeByte(params)))).setUserInteraction(this.createUserInteraction(threeDsData, params)));
    }

    private UserInteraction createUserInteraction(ThreeDsData threeDsData, Map<String, String> parameters) {
        if (threeDsData.getHttpMethod() == HttpMethod.GET) {
            return ProxyProviderPackageCreators.createGetUserInteraction((String)threeDsData.getAcsUrl());
        }
        return ProxyProviderPackageCreators.createPostUserInteraction((String)threeDsData.getAcsUrl(), parameters);
    }

    @Override
    public Intent createFinishIntentSuccess() {
        return Intent.finish((FinishIntent)new FinishIntent(FinishStatus.success((Success)new Success())));
    }

    @Override
    public Intent createSleepIntentWithExponentialPolling(ExitStateModel exitStateModel) {
        EntryStateModel entryStateModel = exitStateModel.getEntryStateModel();
        PollingInfo pollingInfo = this.pollingInfoService.initPollingInfo(entryStateModel);
        if (this.pollingInfoService.isDeadline(pollingInfo)) {
            return this.createFinishIntentFailed("Sleep timeout", "Max time pool limit reached");
        }
        exitStateModel.setPollingInfo(pollingInfo);
        Map<String, String> adapterConfigurations = entryStateModel.getBaseRequestModel().getAdapterConfigurations();
        int nextTimeoutSec = this.exponentialBackOffPollingService.prepareNextPollingInterval(pollingInfo, adapterConfigurations);
        return Intent.sleep((SleepIntent)new SleepIntent(Timer.timeout((int)nextTimeoutSec)));
    }

    @Override
    public Intent createFinishIntentFailed(ExitStateModel exitStateModel) {
        return Intent.finish((FinishIntent)new FinishIntent(FinishStatus.failure((Failure)this.errorMapping.mapFailure(exitStateModel.getErrorCode(), exitStateModel.getErrorMessage()))));
    }

    @Override
    public Intent createFinishIntentFailed(String errorCode, String errorMessage) {
        return Intent.finish((FinishIntent)new FinishIntent(FinishStatus.failure((Failure)this.errorMapping.mapFailure(errorCode, errorMessage))));
    }

    public SimpleIntentResultFactory(TimerProperties timerProperties, CallbackUrlExtractor callbackUrlExtractor, TagManagementService tagManagementService, ParametersSerializer parametersSerializer, PollingInfoService pollingInfoService, ErrorMapping errorMapping, ExponentialBackOffPollingService exponentialBackOffPollingService) {
        this.timerProperties = timerProperties;
        this.callbackUrlExtractor = callbackUrlExtractor;
        this.tagManagementService = tagManagementService;
        this.parametersSerializer = parametersSerializer;
        this.pollingInfoService = pollingInfoService;
        this.errorMapping = errorMapping;
        this.exponentialBackOffPollingService = exponentialBackOffPollingService;
    }
}

