/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.handler;

import dev.vality.adapter.common.damsel.ProxyProviderPackageExtractors;
import dev.vality.adapter.common.damsel.ProxyProviderVerification;
import dev.vality.adapter.flow.lib.utils.PaymentResourceTypeResolver;
import dev.vality.damsel.proxy_provider.PaymentCallbackResult;
import dev.vality.damsel.proxy_provider.PaymentContext;
import dev.vality.damsel.proxy_provider.PaymentProxyResult;
import dev.vality.damsel.proxy_provider.ProviderProxySrv;
import dev.vality.damsel.proxy_provider.RecurrentTokenCallbackResult;
import dev.vality.damsel.proxy_provider.RecurrentTokenContext;
import dev.vality.damsel.proxy_provider.RecurrentTokenProxyResult;
import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerHandlerLogDecorator
implements ProviderProxySrv.Iface {
    private static final Logger log = LoggerFactory.getLogger(ServerHandlerLogDecorator.class);
    private final ProviderProxySrv.Iface handler;

    public RecurrentTokenProxyResult generateToken(RecurrentTokenContext context) throws TException {
        String recurrentId = ProxyProviderPackageExtractors.extractRecurrentId((RecurrentTokenContext)context);
        log.info("Generate token started with recurrentId {}", (Object)recurrentId);
        try {
            RecurrentTokenProxyResult proxyResult = this.handler.generateToken(context);
            log.info("Generate token finished {} with recurrentId {}", (Object)proxyResult, (Object)recurrentId);
            return proxyResult;
        }
        catch (Exception ex) {
            String message = "Failed handle generate token with recurrentId " + recurrentId;
            ServerHandlerLogDecorator.logMessage(ex, message);
            throw ex;
        }
    }

    public RecurrentTokenCallbackResult handleRecurrentTokenCallback(ByteBuffer byteBuffer, RecurrentTokenContext context) throws TException {
        String recurrentId = ProxyProviderPackageExtractors.extractRecurrentId((RecurrentTokenContext)context);
        log.info("handleRecurrentTokenCallback: start with recurrentId {}", (Object)recurrentId);
        RecurrentTokenCallbackResult result = this.handler.handleRecurrentTokenCallback(byteBuffer, context);
        log.info("handleRecurrentTokenCallback end {} with recurrentId {}", (Object)result, (Object)recurrentId);
        return result;
    }

    public PaymentProxyResult processPayment(PaymentContext context) throws TException {
        String invoiceId = ProxyProviderPackageExtractors.extractInvoiceId((PaymentContext)context);
        String invoicePaymentStatus = ProxyProviderPackageExtractors.extractTargetInvoicePaymentStatus((PaymentContext)context);
        String paymentResourceType = PaymentResourceTypeResolver.extractPaymentResourceType(context);
        log.info("Process payment handle resource='{}', status='{}' start with invoiceId {}", new Object[]{paymentResourceType, invoicePaymentStatus, invoiceId});
        try {
            PaymentProxyResult proxyResult = this.handler.processPayment(context);
            log.info("Process payment handle resource='{}', status='{}' finished with invoiceId {} and proxyResult {}", new Object[]{paymentResourceType, invoicePaymentStatus, invoiceId, proxyResult});
            return proxyResult;
        }
        catch (Exception e) {
            String message = String.format("Failed handle resource=%s, status=%s process payment for operation with invoiceId %s", paymentResourceType, invoicePaymentStatus, invoiceId);
            ServerHandlerLogDecorator.logMessage(e, message);
            throw e;
        }
    }

    public PaymentCallbackResult handlePaymentCallback(ByteBuffer byteBuffer, PaymentContext context) throws TException {
        String invoiceId = ProxyProviderPackageExtractors.extractInvoiceId((PaymentContext)context);
        log.info("handlePaymentCallback start with invoiceId {}", (Object)invoiceId);
        PaymentCallbackResult result = this.handler.handlePaymentCallback(byteBuffer, context);
        log.info("handlePaymentCallback finish {} with invoiceId {}", (Object)result, (Object)invoiceId);
        return result;
    }

    private static void logMessage(Exception ex, String message) {
        if (ProxyProviderVerification.isUndefinedResultOrUnavailable((Exception)ex)) {
            log.warn(message, (Throwable)ex);
        } else {
            log.error(message, (Throwable)ex);
        }
    }

    public ServerHandlerLogDecorator(ProviderProxySrv.Iface handler) {
        this.handler = handler;
    }
}

