/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.service.factory;

import dev.vality.adapter.common.damsel.OptionsExtractors;
import dev.vality.adapter.common.damsel.ProxyProviderPackageCreators;
import dev.vality.adapter.common.mapper.ErrorMapping;
import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.ExitStateModel;
import dev.vality.adapter.flow.lib.model.PollingInfo;
import dev.vality.adapter.flow.lib.model.QrDisplayData;
import dev.vality.adapter.flow.lib.serde.ParametersSerializer;
import dev.vality.adapter.flow.lib.service.ExponentialBackOffPollingService;
import dev.vality.adapter.flow.lib.service.PollingInfoService;
import dev.vality.adapter.flow.lib.service.TagManagementService;
import dev.vality.adapter.flow.lib.service.factory.IntentResultFactory;
import dev.vality.adapter.flow.lib.utils.TimeoutUtils;
import dev.vality.adapter.flow.lib.utils.TimerProperties;
import dev.vality.damsel.base.Timer;
import dev.vality.damsel.domain.Failure;
import dev.vality.damsel.proxy_provider.FinishIntent;
import dev.vality.damsel.proxy_provider.FinishStatus;
import dev.vality.damsel.proxy_provider.Intent;
import dev.vality.damsel.proxy_provider.SleepIntent;
import dev.vality.damsel.proxy_provider.Success;
import dev.vality.damsel.proxy_provider.SuspendIntent;
import dev.vality.damsel.timeout_behaviour.TimeoutBehaviour;
import dev.vality.damsel.user_interaction.QrCode;
import dev.vality.damsel.user_interaction.QrCodeDisplayRequest;
import dev.vality.damsel.user_interaction.UserInteraction;
import java.nio.ByteBuffer;
import java.util.Map;

public class IntentResultQrPaymentFactory
implements IntentResultFactory {
    private final TimerProperties timerProperties;
    private final TagManagementService tagManagementService;
    private final ParametersSerializer parametersSerializer;
    private final PollingInfoService pollingInfoService;
    private final ErrorMapping errorMapping;
    private final ExponentialBackOffPollingService exponentialBackOffPollingService;

    @Override
    public Intent createFinishIntentSuccessWithCheckToken(ExitStateModel exitStateModel) {
        EntryStateModel entryStateModel = exitStateModel.getEntryStateModel();
        if (entryStateModel.getBaseRequestModel().getRecurrentPaymentData() != null && entryStateModel.getBaseRequestModel().getRecurrentPaymentData().isMakeRecurrent()) {
            return ProxyProviderPackageCreators.createFinishIntentSuccessWithToken((String)exitStateModel.getRecToken());
        }
        return this.createFinishIntentSuccess();
    }

    @Override
    public Intent createSuspendIntentWithFailedAfterTimeout(ExitStateModel exitStateModel) {
        EntryStateModel entryStateModel = exitStateModel.getEntryStateModel();
        QrDisplayData qrDisplayData = exitStateModel.getQrDisplayData();
        Map<String, String> adapterConfigurations = entryStateModel.getBaseRequestModel().getAdapterConfigurations();
        int timerRedirectTimeoutMin = OptionsExtractors.extractRedirectTimeout(adapterConfigurations, (int)this.timerProperties.getRedirectTimeoutMin());
        return Intent.suspend((SuspendIntent)new SuspendIntent(this.tagManagementService.initTag(qrDisplayData.getTagId()), Timer.timeout((int)TimeoutUtils.toSeconds(timerRedirectTimeoutMin))).setUserInteraction(UserInteraction.qr_code_display_request((QrCodeDisplayRequest)new QrCodeDisplayRequest().setQrCode(new QrCode().setPayload(qrDisplayData.getQrUrl().getBytes())))));
    }

    @Override
    public Intent createSuspendIntentWithCallbackAfterTimeout(ExitStateModel exitStateModel) {
        QrDisplayData qrDisplayData = exitStateModel.getQrDisplayData();
        EntryStateModel entryStateModel = exitStateModel.getEntryStateModel();
        PollingInfo pollingInfo = this.pollingInfoService.initPollingInfo(entryStateModel);
        if (this.pollingInfoService.isDeadline(pollingInfo)) {
            return this.createFinishIntentFailed("Sleep timeout", "Max time pool limit reached");
        }
        exitStateModel.setPollingInfo(pollingInfo);
        Map<String, String> adapterConfigurations = entryStateModel.getBaseRequestModel().getAdapterConfigurations();
        int timerRedirectTimeoutMin = OptionsExtractors.extractRedirectTimeout(adapterConfigurations, (int)this.timerProperties.getRedirectTimeoutMin());
        String tag = this.tagManagementService.initTag(qrDisplayData.getTagId());
        return Intent.suspend((SuspendIntent)new SuspendIntent(tag, Timer.timeout((int)TimeoutUtils.toSeconds(timerRedirectTimeoutMin))).setTimeoutBehaviour(TimeoutBehaviour.callback((ByteBuffer)ByteBuffer.wrap(this.parametersSerializer.writeByte(Map.of("tag", tag))))).setUserInteraction(UserInteraction.qr_code_display_request((QrCodeDisplayRequest)new QrCodeDisplayRequest().setQrCode(new QrCode().setPayload(qrDisplayData.getQrUrl().getBytes())))));
    }

    @Override
    public Intent createFinishIntentSuccess() {
        return Intent.finish((FinishIntent)new FinishIntent(FinishStatus.success((Success)new Success())));
    }

    @Override
    public Intent createSleepIntentWithExponentialPolling(ExitStateModel exitStateModel) {
        EntryStateModel entryStateModel = exitStateModel.getEntryStateModel();
        PollingInfo pollingInfo = this.pollingInfoService.initPollingInfo(entryStateModel);
        if (this.pollingInfoService.isDeadline(pollingInfo)) {
            return this.createFinishIntentFailed("Sleep timeout", "Max time pool limit reached");
        }
        exitStateModel.setPollingInfo(pollingInfo);
        Map<String, String> adapterConfigurations = entryStateModel.getBaseRequestModel().getAdapterConfigurations();
        int nextTimeoutSec = this.exponentialBackOffPollingService.prepareNextPollingInterval(pollingInfo, adapterConfigurations);
        return Intent.sleep((SleepIntent)new SleepIntent(Timer.timeout((int)nextTimeoutSec)));
    }

    @Override
    public Intent createFinishIntentFailed(ExitStateModel exitStateModel) {
        return Intent.finish((FinishIntent)new FinishIntent(FinishStatus.failure((Failure)this.errorMapping.mapFailure(exitStateModel.getErrorCode(), exitStateModel.getErrorMessage()))));
    }

    @Override
    public Intent createFinishIntentFailed(String errorCode, String errorMessage) {
        return Intent.finish((FinishIntent)new FinishIntent(FinishStatus.failure((Failure)this.errorMapping.mapFailure(errorCode, errorMessage))));
    }

    public IntentResultQrPaymentFactory(TimerProperties timerProperties, TagManagementService tagManagementService, ParametersSerializer parametersSerializer, PollingInfoService pollingInfoService, ErrorMapping errorMapping, ExponentialBackOffPollingService exponentialBackOffPollingService) {
        this.timerProperties = timerProperties;
        this.tagManagementService = tagManagementService;
        this.parametersSerializer = parametersSerializer;
        this.pollingInfoService = pollingInfoService;
        this.errorMapping = errorMapping;
        this.exponentialBackOffPollingService = exponentialBackOffPollingService;
    }
}

