/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.processor;

import dev.vality.adapter.flow.lib.constant.Status;
import dev.vality.adapter.flow.lib.model.BaseResponseModel;
import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.ExitStateModel;
import dev.vality.adapter.flow.lib.processor.Processor;
import dev.vality.adapter.flow.lib.utils.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrDisplayProcessor
implements Processor<ExitStateModel, BaseResponseModel, EntryStateModel> {
    private static final Logger log = LoggerFactory.getLogger(QrDisplayProcessor.class);
    private final Processor<ExitStateModel, BaseResponseModel, EntryStateModel> nextProcessor;

    @Override
    public ExitStateModel process(BaseResponseModel response, EntryStateModel entryStateModel) {
        if (response.getStatus() == Status.NEED_REDIRECT && !ErrorUtils.isError(response) && response.getQrDisplayData() != null && response.getQrDisplayData().getQrUrl() != null) {
            log.debug("Start qr display process response: {} entryStateModel: {}", (Object)response, (Object)entryStateModel);
            ExitStateModel exitStateModel = new ExitStateModel();
            exitStateModel.setQrDisplayData(response.getQrDisplayData());
            exitStateModel.setLastOperationStatus(response.getStatus());
            exitStateModel.setProviderTrxId(response.getProviderTrxId());
            exitStateModel.setTrxExtra(response.getSaveData());
            exitStateModel.setAdditionalTrxInfo(response.getAdditionalTrxInfo());
            exitStateModel.setCustomContext(response.getCustomContext());
            log.debug("Finish qr display process response: {} entryStateModel: {}", (Object)response, (Object)entryStateModel);
            return exitStateModel;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(response, entryStateModel);
        }
        throw new IllegalStateException("Processor didn't match for response " + response);
    }

    public QrDisplayProcessor(Processor<ExitStateModel, BaseResponseModel, EntryStateModel> nextProcessor) {
        this.nextProcessor = nextProcessor;
    }
}

