/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.utils;

import dev.vality.adapter.flow.lib.constant.RedirectFields;
import dev.vality.adapter.flow.lib.utils.AdapterProperties;
import java.util.Map;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class CallbackUrlExtractor {
    public static final String TERMINATION_URI = "termination_uri";
    private final AdapterProperties adapterProperties;

    public String extractCallbackUrl(String redirectUrl) {
        return UriComponentsBuilder.fromUriString((String)this.adapterProperties.getCallbackUrl()).path(this.adapterProperties.getPathCallbackUrl()).queryParam(TERMINATION_URI, new Object[]{redirectUrl}).build().toUriString();
    }

    public String getSuccessRedirectUrl(Map<String, String> adapterConfigurations, String redirectUrl) {
        if (StringUtils.hasText((String)redirectUrl)) {
            return redirectUrl;
        }
        return adapterConfigurations.getOrDefault(RedirectFields.TERM_URL.getValue(), this.adapterProperties.getSuccessRedirectUrl());
    }

    public CallbackUrlExtractor(AdapterProperties adapterProperties) {
        this.adapterProperties = adapterProperties;
    }
}

