/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.converter.entry;

import dev.vality.adapter.flow.lib.model.BaseRequestModel;
import dev.vality.adapter.flow.lib.model.CardData;
import dev.vality.adapter.flow.lib.model.Currency;
import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.MobilePaymentData;
import dev.vality.adapter.flow.lib.model.PayerInfo;
import dev.vality.adapter.flow.lib.model.RecurrentPaymentData;
import dev.vality.adapter.flow.lib.model.RefundData;
import dev.vality.adapter.flow.lib.model.TemporaryContext;
import dev.vality.adapter.flow.lib.serde.TemporaryContextDeserializer;
import dev.vality.adapter.flow.lib.service.IdGenerator;
import dev.vality.adapter.flow.lib.service.TemporaryContextService;
import dev.vality.adapter.flow.lib.utils.CardDataUtils;
import dev.vality.cds.client.storage.CdsClientStorage;
import dev.vality.cds.client.storage.utils.BankCardExtractor;
import dev.vality.cds.storage.Auth3DS;
import dev.vality.cds.storage.SessionData;
import dev.vality.damsel.domain.BankCard;
import dev.vality.damsel.domain.DisposablePaymentResource;
import dev.vality.damsel.domain.PaymentTool;
import dev.vality.damsel.domain.TransactionInfo;
import dev.vality.damsel.proxy_provider.RecurrentPaymentTool;
import dev.vality.damsel.proxy_provider.RecurrentTokenContext;
import dev.vality.damsel.proxy_provider.RecurrentTokenInfo;
import dev.vality.java.cds.utils.model.CardDataProxyModel;
import dev.vality.java.damsel.utils.creators.ProxyProviderPackageCreators;
import dev.vality.java.damsel.utils.extractors.ProxyProviderPackageExtractors;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class RecCtxToEntryModelConverter
implements Converter<RecurrentTokenContext, EntryStateModel> {
    private static final Logger log = LoggerFactory.getLogger(RecCtxToEntryModelConverter.class);
    private final TemporaryContextDeserializer temporaryContextDeserializer;
    private final CdsClientStorage cdsStorage;
    private final IdGenerator idGenerator;
    private final TemporaryContextService temporaryContextService;

    public EntryStateModel convert(RecurrentTokenContext context) {
        TemporaryContext generalExitStateModel = this.temporaryContextService.getTemporaryContext(context, this.temporaryContextDeserializer);
        RecurrentTokenInfo tokenInfo = context.getTokenInfo();
        RecurrentPaymentTool recurrentPaymentTool = tokenInfo.getPaymentTool();
        DisposablePaymentResource paymentResource = recurrentPaymentTool.getPaymentResource();
        PaymentTool paymentTool = paymentResource.getPaymentTool();
        this.validatePaymentTool(paymentTool);
        EntryStateModel.EntryStateModelBuilder<?, ?> entryStateModelBuilder = EntryStateModel.builder();
        CardData cardData = this.initCardData(context, generalExitStateModel, paymentResource);
        MobilePaymentData mobilePaymentData = this.initMobilePaymentData(context, generalExitStateModel);
        TransactionInfo transactionInfo = tokenInfo.getTrx();
        Long orderId = this.idGenerator.get(tokenInfo.getPaymentTool().getId());
        TemporaryContext temporaryContext = this.temporaryContextService.getTemporaryContext(context, this.temporaryContextDeserializer);
        return ((EntryStateModel.EntryStateModelBuilder)((EntryStateModel.EntryStateModelBuilder)((EntryStateModel.EntryStateModelBuilder)entryStateModelBuilder.baseRequestModel((BaseRequestModel)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)BaseRequestModel.builder().recurrentPaymentData((RecurrentPaymentData)((RecurrentPaymentData.RecurrentPaymentDataBuilder)((RecurrentPaymentData.RecurrentPaymentDataBuilder)RecurrentPaymentData.builder().makeRecurrent(true)).recToken(transactionInfo != null && transactionInfo.getExtra() != null ? (String)transactionInfo.getExtra().get("meta_rec_token") : null)).build())).mobilePaymentData(mobilePaymentData)).cardData(cardData)).refundData(this.initRefundData(recurrentPaymentTool, orderId))).paymentId(orderId)).currency((Currency)((Currency.CurrencyBuilder)((Currency.CurrencyBuilder)Currency.builder().symbolicCode(recurrentPaymentTool.getMinimalPaymentCost().getCurrency().getSymbolicCode())).numericCode(recurrentPaymentTool.getMinimalPaymentCost().getCurrency().getNumericCode())).build())).amount(recurrentPaymentTool.getMinimalPaymentCost().getAmount())).details(recurrentPaymentTool.getId())).payerInfo((PayerInfo)((PayerInfo.PayerInfoBuilder)PayerInfo.builder().ip(ProxyProviderPackageCreators.extractIpAddress((RecurrentTokenContext)context))).build())).adapterConfigurations(context.getOptions())).providerTrxId(transactionInfo != null ? transactionInfo.getId() : null)).savedData(transactionInfo == null || transactionInfo.getExtra() == null ? new HashMap() : transactionInfo.getExtra())).threeDsDataFromMpiCallback(temporaryContext.getThreeDsData())).build())).currentStep(generalExitStateModel.getNextStep())).startedPollingInfo(temporaryContext.getPollingInfo())).build();
    }

    private CardData initCardData(RecurrentTokenContext context, TemporaryContext generalExitStateModel, DisposablePaymentResource paymentResource) {
        SessionData sessionData;
        CardData.CardDataBuilder<?, ?> cardDataBuilder = CardData.builder();
        if (!(generalExitStateModel != null && generalExitStateModel.getNextStep() != null || (sessionData = this.cdsStorage.getSessionData(context)).getAuthData().isSetAuth3ds())) {
            CardDataProxyModel cardData = this.getCardData(context, paymentResource);
            ((CardData.CardDataBuilder)((CardData.CardDataBuilder)((CardData.CardDataBuilder)((CardData.CardDataBuilder)cardDataBuilder.cardHolder(cardData.getCardholderName())).pan(cardData.getPan())).cvv2(CardDataUtils.extractCvv2(sessionData))).expYear(cardData.getExpYear())).expMonth(cardData.getExpMonth());
        }
        return cardDataBuilder.build();
    }

    private MobilePaymentData initMobilePaymentData(RecurrentTokenContext context, TemporaryContext generalExitStateModel) {
        SessionData sessionData;
        MobilePaymentData.MobilePaymentDataBuilder<?, ?> mobilePaymentDataBuilder = MobilePaymentData.builder();
        if ((generalExitStateModel == null || generalExitStateModel.getNextStep() == null) && (sessionData = this.cdsStorage.getSessionData(context)).getAuthData().isSetAuth3ds()) {
            Auth3DS auth3ds = sessionData.getAuthData().getAuth3ds();
            ((MobilePaymentData.MobilePaymentDataBuilder)mobilePaymentDataBuilder.cryptogram(auth3ds.getCryptogram())).eci(auth3ds.getEci());
        }
        return mobilePaymentDataBuilder.build();
    }

    private void validatePaymentTool(PaymentTool paymentTool) {
        if (!paymentTool.isSetBankCard()) {
            throw new IllegalArgumentException("Wrong recurrentPaymentTool. It should be bank card");
        }
    }

    private RefundData initRefundData(RecurrentPaymentTool recurrentPaymentTool, Long orderId) {
        return RefundData.builder().id(String.valueOf(orderId)).amount(recurrentPaymentTool.getMinimalPaymentCost().getAmount()).build();
    }

    private CardDataProxyModel getCardData(RecurrentTokenContext context, DisposablePaymentResource paymentResource) {
        String cardToken = ProxyProviderPackageExtractors.extractBankCardToken((DisposablePaymentResource)paymentResource);
        dev.vality.cds.storage.CardData cardData = this.cdsStorage.getCardData(cardToken);
        BankCard bankCard = ProxyProviderPackageExtractors.extractBankCard((RecurrentTokenContext)context);
        return BankCardExtractor.initCardDataProxyModel((BankCard)bankCard, (dev.vality.cds.storage.CardData)cardData);
    }

    public RecCtxToEntryModelConverter(TemporaryContextDeserializer temporaryContextDeserializer, CdsClientStorage cdsStorage, IdGenerator idGenerator, TemporaryContextService temporaryContextService) {
        this.temporaryContextDeserializer = temporaryContextDeserializer;
        this.cdsStorage = cdsStorage;
        this.idGenerator = idGenerator;
        this.temporaryContextService = temporaryContextService;
    }
}

