/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.converter.entry;

import dev.vality.adapter.flow.lib.constant.Step;
import dev.vality.adapter.flow.lib.constant.TargetStatus;
import dev.vality.adapter.flow.lib.model.BaseRequestModel;
import dev.vality.adapter.flow.lib.model.CardData;
import dev.vality.adapter.flow.lib.model.Currency;
import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.MobilePaymentData;
import dev.vality.adapter.flow.lib.model.PayerInfo;
import dev.vality.adapter.flow.lib.model.RecurrentPaymentData;
import dev.vality.adapter.flow.lib.model.RefundData;
import dev.vality.adapter.flow.lib.model.TemporaryContext;
import dev.vality.adapter.flow.lib.serde.TemporaryContextDeserializer;
import dev.vality.adapter.flow.lib.service.IdGenerator;
import dev.vality.adapter.flow.lib.service.TemporaryContextService;
import dev.vality.adapter.flow.lib.utils.CallbackUrlExtractor;
import dev.vality.adapter.flow.lib.utils.CardDataUtils;
import dev.vality.adapter.flow.lib.utils.TargetStatusResolver;
import dev.vality.cds.client.storage.CdsClientStorage;
import dev.vality.cds.client.storage.utils.BankCardExtractor;
import dev.vality.cds.storage.Auth3DS;
import dev.vality.cds.storage.SessionData;
import dev.vality.damsel.domain.BankCard;
import dev.vality.damsel.domain.TransactionInfo;
import dev.vality.damsel.proxy_provider.InvoicePayment;
import dev.vality.damsel.proxy_provider.InvoicePaymentRefund;
import dev.vality.damsel.proxy_provider.PaymentContext;
import dev.vality.damsel.proxy_provider.PaymentInfo;
import dev.vality.damsel.proxy_provider.PaymentResource;
import dev.vality.java.cds.utils.model.CardDataProxyModel;
import dev.vality.java.damsel.utils.creators.ProxyProviderPackageCreators;
import dev.vality.java.damsel.utils.extractors.ProxyProviderPackageExtractors;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;

public class CtxToEntryModelConverter
implements Converter<PaymentContext, EntryStateModel> {
    private final CdsClientStorage cdsStorage;
    private final TemporaryContextDeserializer temporaryContextDeserializer;
    private final IdGenerator idGenerator;
    private final TemporaryContextService temporaryContextService;
    private final CallbackUrlExtractor callbackUrlExtractor;

    public EntryStateModel convert(PaymentContext context) {
        PaymentInfo paymentInfo = context.getPaymentInfo();
        InvoicePayment payment = paymentInfo.getPayment();
        TemporaryContext temporaryContext = this.temporaryContextService.getTemporaryContext(context, this.temporaryContextDeserializer);
        PaymentResource paymentResource = payment.getPaymentResource();
        Step currentStep = temporaryContext.getNextStep();
        TargetStatus targetStatus = TargetStatusResolver.extractTargetStatus(context.getSession().getTarget());
        CardData cardData = null;
        MobilePaymentData mobilePaymentData = null;
        if (paymentResource.isSetDisposablePaymentResource() && currentStep == null && targetStatus == TargetStatus.PROCESSED) {
            SessionData sessionData = this.cdsStorage.getSessionData(context);
            cardData = this.initCardData(context, paymentResource, sessionData);
            mobilePaymentData = this.initMobilePaymentData(sessionData);
        }
        TransactionInfo trx = payment.getTrx();
        RecurrentPaymentData recurrentPaymentData = this.initRecurrentPaymentData(payment, paymentResource, trx);
        Map adapterConfigurations = context.getOptions();
        return ((EntryStateModel.EntryStateModelBuilder)((EntryStateModel.EntryStateModelBuilder)((EntryStateModel.EntryStateModelBuilder)((EntryStateModel.EntryStateModelBuilder)EntryStateModel.builder().baseRequestModel((BaseRequestModel)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)((BaseRequestModel.BaseRequestModelBuilder)BaseRequestModel.builder().recurrentPaymentData(recurrentPaymentData)).mobilePaymentData(mobilePaymentData)).cardData(cardData)).refundData(this.initRefundData(paymentInfo))).paymentId(this.idGenerator.get(paymentInfo.getInvoice().getId()))).createdAt(paymentInfo.getPayment().getCreatedAt())).currency((Currency)((Currency.CurrencyBuilder)((Currency.CurrencyBuilder)Currency.builder().symbolicCode(payment.getCost().getCurrency().getSymbolicCode())).numericCode(payment.getCost().getCurrency().getNumericCode())).build())).amount(payment.getCost().getAmount())).details(paymentInfo.getInvoice().getDetails().getDescription())).payerInfo((PayerInfo)((PayerInfo.PayerInfoBuilder)PayerInfo.builder().ip(ProxyProviderPackageCreators.extractIpAddress((PaymentContext)context))).build())).adapterConfigurations(adapterConfigurations)).providerTrxId(trx != null ? trx.getId() : temporaryContext.getProviderTrxId())).savedData(trx != null ? trx.getExtra() : new HashMap())).successRedirectUrl(this.getSuccessRedirectUrl(payment, adapterConfigurations))).threeDsDataFromMpiCallback(temporaryContext.getThreeDsData())).build())).targetStatus(targetStatus)).currentStep(currentStep)).startedPollingInfo(temporaryContext.getPollingInfo())).build();
    }

    private String getSuccessRedirectUrl(InvoicePayment payment, Map<String, String> adapterConfigurations) {
        return this.callbackUrlExtractor.getSuccessRedirectUrl(adapterConfigurations, payment.isSetPayerSessionInfo() ? payment.getPayerSessionInfo().getRedirectUrl() : null);
    }

    private CardData initCardData(PaymentContext context, PaymentResource paymentResource, SessionData sessionData) {
        CardData.CardDataBuilder<?, ?> cardDataBuilder = CardData.builder();
        if (!this.isMobilePay(sessionData)) {
            CardDataProxyModel cardData = this.getCardData(context, paymentResource);
            ((CardData.CardDataBuilder)((CardData.CardDataBuilder)((CardData.CardDataBuilder)((CardData.CardDataBuilder)cardDataBuilder.cardHolder(cardData.getCardholderName())).pan(cardData.getPan())).cvv2(CardDataUtils.extractCvv2(sessionData))).expYear(cardData.getExpYear())).expMonth(cardData.getExpMonth());
        }
        return cardDataBuilder.build();
    }

    private MobilePaymentData initMobilePaymentData(SessionData sessionData) {
        MobilePaymentData.MobilePaymentDataBuilder<?, ?> mobilePaymentDataBuilder = MobilePaymentData.builder();
        if (this.isMobilePay(sessionData)) {
            Auth3DS auth3ds = sessionData.getAuthData().getAuth3ds();
            ((MobilePaymentData.MobilePaymentDataBuilder)mobilePaymentDataBuilder.cryptogram(auth3ds.getCryptogram())).eci(auth3ds.getEci());
        }
        return mobilePaymentDataBuilder.build();
    }

    private boolean isMobilePay(SessionData sessionData) {
        return sessionData.isSetAuthData() && sessionData.getAuthData().isSetAuth3ds();
    }

    private RefundData initRefundData(PaymentInfo paymentInfo) {
        RefundData refundData = null;
        if (paymentInfo.isSetRefund()) {
            InvoicePaymentRefund refund = paymentInfo.getRefund();
            refundData = RefundData.builder().id(refund.getId()).amount(refund.getCash().getAmount()).build();
        }
        return refundData;
    }

    private RecurrentPaymentData initRecurrentPaymentData(InvoicePayment payment, PaymentResource paymentResource, TransactionInfo transactionInfo) {
        Object recurrentPaymentDataBuilder = RecurrentPaymentData.builder().makeRecurrent(payment.make_recurrent);
        if (paymentResource.isSetRecurrentPaymentResource()) {
            ((RecurrentPaymentData.RecurrentPaymentDataBuilder)recurrentPaymentDataBuilder).recToken(paymentResource.getRecurrentPaymentResource().getRecToken());
        } else if (transactionInfo != null && transactionInfo.getExtra() != null && transactionInfo.getExtra().containsKey("meta_rec_token")) {
            ((RecurrentPaymentData.RecurrentPaymentDataBuilder)recurrentPaymentDataBuilder).recToken((String)transactionInfo.getExtra().get("meta_rec_token"));
        }
        return ((RecurrentPaymentData.RecurrentPaymentDataBuilder)recurrentPaymentDataBuilder).build();
    }

    private CardDataProxyModel getCardData(PaymentContext context, PaymentResource paymentResource) {
        if (paymentResource.isSetDisposablePaymentResource()) {
            String cardToken = ProxyProviderPackageExtractors.extractBankCardToken((PaymentResource)paymentResource);
            dev.vality.cds.storage.CardData cardData = this.cdsStorage.getCardData(cardToken);
            BankCard bankCard = ProxyProviderPackageExtractors.extractBankCard((PaymentContext)context);
            return BankCardExtractor.initCardDataProxyModel((BankCard)bankCard, (dev.vality.cds.storage.CardData)cardData);
        }
        return this.cdsStorage.getCardData(context);
    }

    public CtxToEntryModelConverter(CdsClientStorage cdsStorage, TemporaryContextDeserializer temporaryContextDeserializer, IdGenerator idGenerator, TemporaryContextService temporaryContextService, CallbackUrlExtractor callbackUrlExtractor) {
        this.cdsStorage = cdsStorage;
        this.temporaryContextDeserializer = temporaryContextDeserializer;
        this.idGenerator = idGenerator;
        this.temporaryContextService = temporaryContextService;
        this.callbackUrlExtractor = callbackUrlExtractor;
    }
}

