/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.service;

import dev.vality.adapter.common.cds.BankCardExtractor;
import dev.vality.adapter.common.cds.CdsStorageClient;
import dev.vality.adapter.common.cds.model.CardDataProxyModel;
import dev.vality.adapter.flow.lib.constant.OptionFields;
import dev.vality.adapter.flow.lib.service.CardDataService;
import dev.vality.adapter.flow.lib.service.CardHolderNamesService;
import dev.vality.cds.storage.CardData;
import dev.vality.damsel.domain.BankCard;
import dev.vality.damsel.proxy_provider.PaymentContext;
import dev.vality.damsel.proxy_provider.RecurrentTokenContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardDataServiceWithHolderNamesImpl
implements CardDataService {
    private static final Logger log = LoggerFactory.getLogger(CardDataServiceWithHolderNamesImpl.class);
    private final CdsStorageClient cdsStorageClient;
    private final CardHolderNamesService cardHolderNamesService;

    @Override
    public CardDataProxyModel getCardDataProxyModel(RecurrentTokenContext context, CardData cardData, BankCard bankCard) {
        if (context.getOptions().containsKey(OptionFields.CARD_HOLDER_FROM_FILE.name())) {
            return BankCardExtractor.initCardDataProxyModel((BankCard)bankCard, (CardData)cardData, this.cardHolderNamesService.getCardHoldersNames());
        }
        return BankCardExtractor.initCardDataProxyModel((BankCard)bankCard, (CardData)cardData);
    }

    @Override
    public CardDataProxyModel getCardDataProxyModel(PaymentContext context, CardData cardData, BankCard bankCard) {
        if (context.getOptions().containsKey(OptionFields.CARD_HOLDER_FROM_FILE.name())) {
            return BankCardExtractor.initCardDataProxyModel((BankCard)bankCard, (CardData)cardData, this.cardHolderNamesService.getCardHoldersNames());
        }
        return BankCardExtractor.initCardDataProxyModel((BankCard)bankCard, (CardData)cardData);
    }

    @Override
    public CardDataProxyModel getCardDataProxyModelFromCds(PaymentContext context) {
        if (context.getOptions().containsKey(OptionFields.CARD_HOLDER_FROM_FILE.name())) {
            return this.cdsStorageClient.getCardDataWithListHolders(context, this.cardHolderNamesService.getCardHoldersNames());
        }
        return this.cdsStorageClient.getCardData(context);
    }

    public CardDataServiceWithHolderNamesImpl(CdsStorageClient cdsStorageClient, CardHolderNamesService cardHolderNamesService) {
        this.cdsStorageClient = cdsStorageClient;
        this.cardHolderNamesService = cardHolderNamesService;
    }
}

