/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.serde;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.vality.adapter.flow.lib.serde.Serializer;
import java.io.IOException;
import java.util.Base64;
import org.apache.commons.lang3.SerializationException;

public abstract class StateSerializer<T>
implements Serializer<T> {
    protected final ObjectMapper mapper;

    @Override
    public byte[] writeByte(Object obj) {
        try {
            return this.mapper.writeValueAsBytes(obj);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    @Override
    public String writeString(Object obj) {
        try {
            return Base64.getEncoder().encodeToString(this.getMapper().writeValueAsBytes(obj));
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public StateSerializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

