/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.service;

import dev.vality.adapter.flow.lib.serde.ParametersDeserializer;
import dev.vality.adapter.flow.lib.serde.ParametersSerializer;
import dev.vality.adapter.flow.lib.service.TagManagementService;
import dev.vality.adapter.helpers.hellgate.HellgateAdapterClient;
import dev.vality.adapter.helpers.hellgate.exception.HellgateException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ThreeDsAdapterService {
    private static final Logger log = LoggerFactory.getLogger(ThreeDsAdapterService.class);
    private final HellgateAdapterClient hgClient;
    private final ParametersSerializer parametersSerializer;
    private final ParametersDeserializer parametersDeserializer;
    private final TagManagementService tagManagementService;

    public String receivePaymentIncomingParameters(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        return this.processCallback(servletRequest, servletResponse, (arg_0, arg_1) -> ((HellgateAdapterClient)this.hgClient).processPaymentCallback(arg_0, arg_1));
    }

    public String receiveRecurrentIncomingParameters(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        return this.processCallback(servletRequest, servletResponse, (arg_0, arg_1) -> ((HellgateAdapterClient)this.hgClient).processRecurrentTokenCallback(arg_0, arg_1));
    }

    private String processCallback(HttpServletRequest servletRequest, HttpServletResponse servletResponse, BiFunction<String, ByteBuffer, ByteBuffer> hgFunction) {
        String resp = "";
        Map<String, String> parameters = this.parametersDeserializer.read(servletRequest);
        log.info("-> callback 3ds {}", parameters);
        try {
            ByteBuffer callback = ByteBuffer.wrap(this.parametersSerializer.writeByte(parameters));
            ByteBuffer response = hgFunction.apply(this.tagManagementService.findTag(parameters), callback);
            resp = new String(response.array(), StandardCharsets.UTF_8);
            if (StringUtils.hasText((String)parameters.get("termination_uri"))) {
                servletResponse.sendRedirect(parameters.get("termination_uri"));
            }
        }
        catch (HellgateException var9) {
            log.warn("Failed handle callback for recurrent", (Throwable)var9);
        }
        catch (Exception var10) {
            log.error("Failed handle callback for recurrent", (Throwable)var10);
        }
        log.info("<- callback 3ds {}", (Object)resp);
        return resp;
    }

    public ThreeDsAdapterService(HellgateAdapterClient hgClient, ParametersSerializer parametersSerializer, ParametersDeserializer parametersDeserializer, TagManagementService tagManagementService) {
        this.hgClient = hgClient;
        this.parametersSerializer = parametersSerializer;
        this.parametersDeserializer = parametersDeserializer;
        this.tagManagementService = tagManagementService;
    }
}

