/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.processor;

import dev.vality.adapter.flow.lib.constant.Status;
import dev.vality.adapter.flow.lib.model.BaseResponseModel;
import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.ExitStateModel;
import dev.vality.adapter.flow.lib.processor.Processor;
import dev.vality.adapter.flow.lib.utils.ErrorUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SuccessFinishProcessor
implements Processor<ExitStateModel, BaseResponseModel, EntryStateModel> {
    private static final Logger log = LoggerFactory.getLogger(SuccessFinishProcessor.class);
    private final Processor<ExitStateModel, BaseResponseModel, EntryStateModel> nextProcessor;

    @Override
    public ExitStateModel process(BaseResponseModel response, EntryStateModel entryStateModel) {
        if (response.getStatus() == Status.SUCCESS && !ErrorUtils.isError(response)) {
            log.debug("Start success process response: {} entryStateModel: {}", (Object)response, (Object)entryStateModel);
            ExitStateModel exitStateModel = new ExitStateModel();
            exitStateModel.setProviderTrxId(StringUtils.hasText((String)response.getProviderTrxId()) ? response.getProviderTrxId() : entryStateModel.getBaseRequestModel().getProviderTrxId());
            exitStateModel.setLastOperationStatus(response.getStatus());
            Map<String, String> saveData = response.getSaveData();
            if (entryStateModel.getBaseRequestModel().getRecurrentPaymentData() != null && entryStateModel.getBaseRequestModel().getRecurrentPaymentData().isMakeRecurrent()) {
                if (saveData == null) {
                    saveData = new HashMap<String, String>();
                }
                String recToken = this.initRecurrentToken(response, entryStateModel);
                saveData.put("meta_rec_token", recToken);
                exitStateModel.setRecToken(recToken);
            }
            exitStateModel.setTrxExtra(saveData);
            log.debug("Finish success process response: {} entryStateModel: {}", (Object)response, (Object)entryStateModel);
            return exitStateModel;
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(response, entryStateModel);
        }
        throw new IllegalStateException("Processor didn't match for response " + response);
    }

    private String initRecurrentToken(BaseResponseModel response, EntryStateModel entryStateModel) {
        if (StringUtils.hasText((String)response.getRecurrentToken())) {
            return response.getRecurrentToken();
        }
        if (entryStateModel.getBaseRequestModel().getRecurrentPaymentData() != null && StringUtils.hasText((String)entryStateModel.getBaseRequestModel().getRecurrentPaymentData().getRecToken())) {
            return entryStateModel.getBaseRequestModel().getRecurrentPaymentData().getRecToken();
        }
        return null;
    }

    public SuccessFinishProcessor(Processor<ExitStateModel, BaseResponseModel, EntryStateModel> nextProcessor) {
        this.nextProcessor = nextProcessor;
    }
}

