/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.flow.simple;

import dev.vality.adapter.flow.lib.constant.Status;
import dev.vality.adapter.flow.lib.constant.Step;
import dev.vality.adapter.flow.lib.flow.ResultIntentResolver;
import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.ExitStateModel;
import dev.vality.adapter.flow.lib.service.IntentResultFactory;
import dev.vality.damsel.proxy_provider.Intent;

public class SimpleRedirectWithPollingResultIntentResolver
implements ResultIntentResolver {
    private final IntentResultFactory intentResultFactory;

    @Override
    public Intent initIntentByStep(ExitStateModel exitStateModel) {
        Step nextStep = exitStateModel.getNextStep();
        EntryStateModel entryStateModel = exitStateModel.getEntryStateModel();
        Step currentStep = entryStateModel.getCurrentStep();
        return switch (nextStep) {
            case Step.CHECK_STATUS -> {
                if (exitStateModel.getLastOperationStatus() == Status.NEED_REDIRECT) {
                    yield this.intentResultFactory.createSuspendIntentWithCallbackAfterTimeout(exitStateModel);
                }
                yield this.intentResultFactory.createSleepIntentWithExponentialPolling(exitStateModel);
            }
            case Step.DO_NOTHING -> this.createIntentByCurrentStep(exitStateModel, currentStep);
            case Step.REFUND, Step.CANCEL -> this.intentResultFactory.createFinishIntentSuccess();
            default -> throw new IllegalStateException("Wrong nextStep: " + nextStep);
        };
    }

    private Intent createIntentByCurrentStep(ExitStateModel exitStateModel, Step currentStep) {
        return switch (currentStep) {
            case Step.CHECK_STATUS, Step.DO_NOTHING, Step.CHECK_NEED_3DS_V2, Step.FINISH_THREE_DS_V1, Step.FINISH_THREE_DS_V2, Step.PAY, Step.AUTH -> this.intentResultFactory.createFinishIntentSuccessWithCheckToken(exitStateModel);
            case Step.REFUND, Step.CANCEL -> this.intentResultFactory.createFinishIntentSuccess();
            default -> throw new IllegalStateException("Wrong currentStep: " + currentStep);
        };
    }

    public SimpleRedirectWithPollingResultIntentResolver(IntentResultFactory intentResultFactory) {
        this.intentResultFactory = intentResultFactory;
    }
}

