/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.flow.lib.service;

import dev.vality.adapter.flow.lib.model.EntryStateModel;
import dev.vality.adapter.flow.lib.model.PollingInfo;
import dev.vality.adapter.flow.lib.utils.TimerProperties;
import dev.vality.java.damsel.utils.extractors.OptionsExtractors;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import lombok.NonNull;

public class PollingInfoService {
    private final TimerProperties timerProperties;

    public PollingInfo initPollingInfo(EntryStateModel entryStateModel) {
        PollingInfo pollingInfo = entryStateModel.getStartedPollingInfo();
        if (pollingInfo == null) {
            pollingInfo = new PollingInfo();
        }
        if (pollingInfo.getStartDateTimePolling() == null) {
            pollingInfo.setStartDateTimePolling(Instant.now());
        }
        Instant maxDateTimePolling = this.calcDeadline(entryStateModel, pollingInfo);
        pollingInfo.setMaxDateTimePolling(maxDateTimePolling);
        return pollingInfo;
    }

    public boolean isDeadline(PollingInfo pollingInfo) {
        Instant now = Instant.now();
        return now.isAfter(pollingInfo.getMaxDateTimePolling());
    }

    private Instant calcDeadline(EntryStateModel entryStateModel, @NonNull PollingInfo pollingInfo) {
        if (pollingInfo == null) {
            throw new NullPointerException("pollingInfo is marked non-null but is null");
        }
        if (pollingInfo.getMaxDateTimePolling() == null) {
            Integer maxTimePolling = OptionsExtractors.extractMaxTimePolling(entryStateModel.getBaseRequestModel().getAdapterConfigurations(), (int)this.timerProperties.getMaxTimePollingMin());
            return pollingInfo.getStartDateTimePolling().plus((long)maxTimePolling.intValue(), ChronoUnit.MINUTES);
        }
        return pollingInfo.getMaxDateTimePolling();
    }

    public PollingInfoService(TimerProperties timerProperties) {
        this.timerProperties = timerProperties;
    }
}

