/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.utils;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;

public class UpperSnakeCaseStrategy
extends PropertyNamingStrategy {
    public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
        return this.convert(field.getName());
    }

    public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
        return this.convert(method.getName());
    }

    public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
        return this.convert(method.getName());
    }

    private String convert(String inputString) {
        if (inputString == null) {
            return inputString;
        }
        Object input = inputString.substring(3);
        if (((String)input).length() > 1 && Character.isUpperCase(((String)input).charAt(0)) && Character.isUpperCase(((String)input).charAt(1))) {
            input = ((String)input).substring(0, 1).toLowerCase() + ((String)input).substring(1);
        }
        int length = ((String)input).length();
        StringBuilder result = new StringBuilder(length * 2);
        int resultLength = 0;
        boolean wasPrevTranslated = false;
        for (int i = 0; i < length; ++i) {
            char c = ((String)input).charAt(i);
            if (i <= 0 && c == '_') continue;
            if (Character.isUpperCase(c)) {
                if (!wasPrevTranslated && resultLength > 0 && result.charAt(resultLength - 1) != '_') {
                    result.append('_');
                    ++resultLength;
                }
                c = Character.toLowerCase(c);
                wasPrevTranslated = true;
            } else {
                wasPrevTranslated = false;
            }
            result.append(c);
            ++resultLength;
        }
        Object finalString = resultLength > 0 ? result.toString() : input;
        return ((String)finalString).toUpperCase();
    }
}

