/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.utils;

import dev.vality.adapter.common.utils.Base62;
import dev.vality.damsel.proxy_provider.PaymentInfo;
import java.math.BigDecimal;
import java.util.Random;

public final class PaymentDataConverter {
    private static final String DEFAULT_ID = "1";

    public static String makeHex16length() {
        return String.format("%016X", new Random().nextLong()).toUpperCase();
    }

    public static BigDecimal prepareFormattedAmount(long amount) {
        return new BigDecimal(amount).movePointLeft(2);
    }

    public static String prepareOrder(String invoiceId) {
        return PaymentDataConverter.prepareOrder(invoiceId, DEFAULT_ID);
    }

    public static String prepareOrder(PaymentInfo paymentInfo) {
        return PaymentDataConverter.prepareOrder(paymentInfo.getInvoice().getId(), paymentInfo.getPayment().getId());
    }

    public static String prepareOrder(String invoiceId, String paymentId) {
        return Long.toString(Math.abs(new Base62().decodeBase62(invoiceId) ^ (long)Integer.parseInt(paymentId)));
    }

    public static String extractEmail(PaymentInfo paymentInfo) {
        if (paymentInfo == null || paymentInfo.getPayment() == null || paymentInfo.getPayment().getContactInfo() == null || paymentInfo.getPayment().getContactInfo().getEmail() == null) {
            return "";
        }
        return paymentInfo.getPayment().getContactInfo().getEmail();
    }

    private PaymentDataConverter() {
    }
}

