/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.utils;

public class Base62 {
    private String characters;

    public Base62() {
        this("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    public Base62(String characters) {
        if (characters.length() != 62) {
            throw new IllegalArgumentException("Invalid string length, must be 62.");
        }
        this.characters = characters;
    }

    public String encodeBase10(Long b10) {
        if (b10 < 0L) {
            throw new IllegalArgumentException("b10 must be nonnegative");
        }
        Object ret = "";
        while (b10 > 0L) {
            ret = this.characters.charAt((int)(b10 % 62L)) + (String)ret;
            b10 = b10 / 62L;
        }
        return ret;
    }

    public long decodeBase62(String b62) {
        for (char character : b62.toCharArray()) {
            if (this.characters.contains(String.valueOf(character))) continue;
            throw new IllegalArgumentException("Invalid character(s) in string: " + character);
        }
        long ret = 0L;
        b62 = new StringBuffer(b62).reverse().toString();
        long count = 1L;
        for (char character : b62.toCharArray()) {
            ret += (long)this.characters.indexOf(character) * count;
            count *= 62L;
        }
        return ret;
    }
}

