/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.secret;

import dev.vality.adapter.common.exception.HexDecodeException;
import dev.vality.adapter.common.exception.SecretAlreadyModifyException;
import dev.vality.adapter.common.exception.SecretNotFoundException;
import dev.vality.adapter.common.exception.SecretPathNotFoundException;
import dev.vality.adapter.common.exception.SecretsNotFoundException;
import dev.vality.adapter.common.secret.DigestAlgorithms;
import dev.vality.adapter.common.secret.DigestSigner;
import dev.vality.adapter.common.secret.HmacAlgorithms;
import dev.vality.adapter.common.secret.HmacSigner;
import dev.vality.adapter.common.secret.SecretObj;
import dev.vality.adapter.common.secret.SecretRef;
import dev.vality.adapter.common.secret.SecretService;
import dev.vality.adapter.common.secret.SecretValue;
import dev.vality.adapter.common.secret.VersionedSecret;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.vault.VaultException;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.support.Versioned;

public class VaultSecretService
implements SecretService {
    private final VaultTemplate vaultTemplate;

    @Override
    public Map<String, SecretValue> getSecrets(String serviceName, String path) throws SecretPathNotFoundException {
        Versioned map = this.vaultTemplate.opsForVersionedKeyValue(serviceName).get(path);
        if (map == null || map.getData() == null) {
            throw new SecretPathNotFoundException(path);
        }
        return ((Map)map.getData()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new SecretValue(e.getValue().toString())));
    }

    @Override
    public VersionedSecret getVersionSecrets(String serviceName, String path) throws SecretPathNotFoundException {
        Versioned map = this.vaultTemplate.opsForVersionedKeyValue(serviceName).get(path);
        if (map == null || !map.hasData() || CollectionUtils.isEmpty((Map)((Map)map.getData())) || this.isEmptyValues((Versioned<Map<String, Object>>)map)) {
            throw new SecretsNotFoundException("Secrets doesn't exist or empty for path %s".formatted(path));
        }
        Map<String, SecretValue> secretes = ((Map)map.getData()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new SecretValue(e.getValue().toString())));
        return new VersionedSecret(secretes, map.getVersion().getVersion());
    }

    private boolean isEmptyValues(Versioned<Map<String, Object>> map) {
        return ((Map)map.getData()).values().stream().noneMatch(o -> StringUtils.hasText((String)o.toString()));
    }

    @Override
    public SecretValue getSecret(String serviceName, SecretRef secretRef) throws SecretNotFoundException {
        String secret = this.getSecretString(serviceName, secretRef);
        return new SecretValue(secret);
    }

    @Override
    public String hmac(String serviceName, String data, SecretRef secretRef, HmacAlgorithms hmacAlgorithm) throws SecretNotFoundException, HexDecodeException {
        String hexSecret = this.getSecretString(serviceName, secretRef);
        return new HmacSigner().sign(data, hexSecret, secretRef, hmacAlgorithm);
    }

    @Override
    public String digest(String serviceName, String data, SecretRef secretRef, DigestAlgorithms algorithm) throws SecretNotFoundException {
        String secret = this.getSecretString(serviceName, secretRef);
        return new DigestSigner().sign(data, secret, algorithm);
    }

    @Override
    public void writeSecret(String serviceName, SecretObj secretObj) {
        this.vaultTemplate.opsForVersionedKeyValue(serviceName).put(secretObj.getPath(), secretObj.getValues());
    }

    @Override
    public Integer writeVersionSecret(String serviceName, SecretObj secretObj) {
        Versioned.Metadata metadata = this.vaultTemplate.opsForVersionedKeyValue(serviceName).put(secretObj.getPath(), secretObj.getValues());
        return metadata.getVersion().getVersion();
    }

    @Override
    public Integer writeWithCas(String serviceName, SecretObj secretObj, Integer version) {
        try {
            Versioned versionedBody = Versioned.create(secretObj.getValues(), (Versioned.Version)Versioned.Version.from((int)version));
            Versioned.Metadata metadata = this.vaultTemplate.opsForVersionedKeyValue(serviceName).put(secretObj.getPath(), (Object)versionedBody);
            return metadata.getVersion().getVersion();
        }
        catch (VaultException e) {
            if (VaultSecretService.isCasError(e)) {
                throw new SecretAlreadyModifyException(e);
            }
            throw e;
        }
    }

    private static boolean isCasError(VaultException e) {
        return Objects.nonNull(e.getMessage()) && e.getMessage().contains("check-and-set parameter did not match the current version");
    }

    private String getSecretString(String serviceName, SecretRef secretRef) throws SecretNotFoundException {
        Versioned map = this.vaultTemplate.opsForVersionedKeyValue(serviceName).get(secretRef.getPath());
        if (map == null || map.getData() == null || ((Map)map.getData()).get(secretRef.getKey()) == null) {
            throw new SecretNotFoundException(secretRef.toString());
        }
        return ((Map)map.getData()).get(secretRef.getKey()).toString();
    }

    public VaultSecretService(VaultTemplate vaultTemplate) {
        this.vaultTemplate = vaultTemplate;
    }
}

