/*
 * Decompiled with CFR 0.152.
 */
package dev.vality.adapter.common.secret;

import dev.vality.adapter.common.exception.HexDecodeException;
import dev.vality.adapter.common.exception.SecretAlreadyModifyException;
import dev.vality.adapter.common.exception.SecretNotFoundException;
import dev.vality.adapter.common.exception.SecretPathNotFoundException;
import dev.vality.adapter.common.exception.SecretsNotFoundException;
import dev.vality.adapter.common.secret.DigestAlgorithms;
import dev.vality.adapter.common.secret.HmacAlgorithms;
import dev.vality.adapter.common.secret.SecretObj;
import dev.vality.adapter.common.secret.SecretRef;
import dev.vality.adapter.common.secret.SecretValue;
import dev.vality.adapter.common.secret.VersionedSecret;
import java.util.Map;

public interface SecretService {
    public Map<String, SecretValue> getSecrets(String var1, String var2) throws SecretPathNotFoundException;

    public VersionedSecret getVersionSecrets(String var1, String var2) throws SecretsNotFoundException;

    public SecretValue getSecret(String var1, SecretRef var2) throws SecretNotFoundException;

    public String hmac(String var1, String var2, SecretRef var3, HmacAlgorithms var4) throws SecretNotFoundException, HexDecodeException;

    public String digest(String var1, String var2, SecretRef var3, DigestAlgorithms var4) throws SecretNotFoundException;

    public void writeSecret(String var1, SecretObj var2);

    public Integer writeVersionSecret(String var1, SecretObj var2);

    public Integer writeWithCas(String var1, SecretObj var2, Integer var3) throws SecretAlreadyModifyException;
}

